/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.versioning;

import host.anzo.commons.utils.ConsoleUtils;
import host.anzo.commons.utils.DateTimeUtils;
import host.anzo.commons.versioning.Locator;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Version.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private String versionRevision;
    private String buildDate = "";
    private String buildJdk = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Class<?> c) {
        block11: {
            File jarName = null;
            try {
                jarName = Locator.getClassSource(c);
                if (StringUtils.endsWith((CharSequence)jarName.getName(), (CharSequence)".jar")) {
                    try (JarFile jarFile = new JarFile(jarName);){
                        Attributes attrs = jarFile.getManifest().getMainAttributes();
                        this.setBuildJdk(attrs);
                        this.setBuildDate(attrs);
                        this.setVersionRevision(attrs);
                        break block11;
                    }
                }
                this.versionRevision = "Dev";
                this.buildDate = DateTimeUtils.getFormattedDateTime(LocalDateTime.now());
                this.buildJdk = System.getProperty("java.version");
            }
            catch (IOException e) {
                log.error("Unable to get soft information. File name '{}' isn't a valid jar", (Object)jarName.getAbsolutePath(), (Object)e);
            }
            finally {
                this.info();
            }
        }
    }

    private void setVersionRevision(@NotNull Attributes attrs) {
        String versionRevision = attrs.getValue("Implementation-Version");
        this.versionRevision = versionRevision != null && !versionRevision.isEmpty() ? versionRevision : "N/A";
    }

    private void setBuildJdk(@NotNull Attributes attrs) {
        String buildJdk = attrs.getValue("Built-JDK");
        this.buildJdk = buildJdk != null ? buildJdk : ((buildJdk = attrs.getValue("Source-Compatibility")) != null ? buildJdk : "-1");
    }

    private void setBuildDate(@NotNull Attributes attrs) {
        String buildDate = attrs.getValue("Built-Date");
        this.buildDate = buildDate != null ? buildDate : "-1";
    }

    private void info() {
        ConsoleUtils.printSection("Build Information");
        log.info("Revision: ................ {}", (Object)this.getVersionRevision());
        log.info("Build date: .............. {}", (Object)this.getBuildDate());
    }

    public String toString() {
        return "Version " + this.versionRevision + " from " + this.buildDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static Version getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    Version actualValue = new Version();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (Version)($value == instance ? null : $value);
    }

    @Generated
    public String getVersionRevision() {
        return this.versionRevision;
    }

    @Generated
    public String getBuildDate() {
        return this.buildDate;
    }

    @Generated
    public String getBuildJdk() {
        return this.buildJdk;
    }
}

