/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.core.service;

import host.anzo.commons.annotations.startup.StartupComponent;
import host.anzo.commons.enums.startup.EShutdownPriority;
import host.anzo.commons.interfaces.startup.IShutdownable;
import host.anzo.commons.objectpool.IObjectPool;
import host.anzo.commons.objectpool.IPoolObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;
import org.jctools.queues.MpmcArrayQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StartupComponent(value="Service", shutdownPriority=EShutdownPriority.MINOR)
public class ObjectPoolService
implements IShutdownable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObjectPoolService.class);
    private static final AtomicReference<Object> instance = new AtomicReference();
    private final Map<String, IObjectPool<?>> pools = new ConcurrentHashMap();

    private ObjectPoolService() {
    }

    public <T> IObjectPool<T> createPool(String poolName, Supplier<T> supplier, int[] params) {
        ObjectPool<T> pool = new ObjectPool<T>(poolName, supplier, params);
        this.pools.put(poolName, pool);
        return pool;
    }

    public void onShutdown() {
        for (IObjectPool<?> pool : this.pools.values()) {
            if (pool == null) continue;
            pool.onShutdown();
        }
        this.pools.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static ObjectPoolService getInstance() {
        Object $value = instance.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = instance;
            synchronized (atomicReference) {
                $value = instance.get();
                if ($value == null) {
                    ObjectPoolService actualValue = new ObjectPoolService();
                    $value = actualValue == null ? instance : actualValue;
                    instance.set($value);
                }
            }
        }
        return (ObjectPoolService)($value == instance ? null : $value);
    }

    @Generated
    public Map<String, IObjectPool<?>> getPools() {
        return this.pools;
    }

    private static class ObjectPool<T>
    implements IObjectPool<T> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(ObjectPool.class);
        private final AtomicBoolean shutdown = new AtomicBoolean(false);
        private final String poolName;
        private final MpmcArrayQueue<T> internalPool;
        private final Supplier<T> supplier;
        private final AtomicLong created = new AtomicLong(0L);
        private final AtomicLong destroyed = new AtomicLong(0L);
        private final AtomicLong borrowed = new AtomicLong(0L);
        private final AtomicLong returned = new AtomicLong(0L);
        private final AtomicLong cleared = new AtomicLong(0L);
        private final AtomicLong empty = new AtomicLong(0L);
        private final AtomicLong errored = new AtomicLong(0L);

        private ObjectPool(String poolName, Supplier<T> supplier, int @NotNull [] params) {
            this.poolName = poolName;
            this.internalPool = new MpmcArrayQueue(params[0]);
            this.supplier = supplier;
            for (int i = 0; i < params[1]; ++i) {
                this.internalPool.offer(supplier.get());
                this.created.incrementAndGet();
            }
            log.info("Object pool {} created.", (Object)poolName);
        }

        @Override
        @Nullable
        public T borrowObject() {
            if (this.shutdown.get()) {
                return null;
            }
            try {
                Object object = this.internalPool.relaxedPoll();
                if (object == null) {
                    object = this.supplier.get();
                    this.created.incrementAndGet();
                }
                this.borrowed.incrementAndGet();
                return (T)object;
            }
            catch (Exception e) {
                log.error("Error borrowing object from pool {}.", (Object)this.poolName, (Object)e);
                this.errored.incrementAndGet();
                return null;
            }
        }

        @Override
        public void returnObject(T object) {
            if (this.shutdown.get() || object == null) {
                return;
            }
            try {
                IPoolObject poolObject;
                if (object instanceof IPoolObject) {
                    poolObject = (IPoolObject)object;
                    poolObject.beforeReturn();
                    this.cleared.incrementAndGet();
                }
                if (this.internalPool.relaxedOffer(object)) {
                    this.returned.incrementAndGet();
                } else if (object instanceof IPoolObject) {
                    poolObject = (IPoolObject)object;
                    poolObject.onDestroy();
                    this.destroyed.incrementAndGet();
                }
            }
            catch (Exception e) {
                log.warn("Error returning object to pool {}.", (Object)this.poolName, (Object)e);
                this.errored.incrementAndGet();
            }
        }

        @Override
        public void onShutdown() {
            if (this.shutdown.compareAndSet(false, true)) {
                while (!this.internalPool.isEmpty()) {
                    Object object = this.internalPool.poll();
                    if (!(object instanceof IPoolObject)) continue;
                    IPoolObject poolObject = (IPoolObject)object;
                    poolObject.onDestroy();
                    this.destroyed.incrementAndGet();
                }
            }
        }

        @Override
        public String getName() {
            return this.poolName;
        }

        @NotNull
        public String toString() {
            return "ObjectPool{" + this.poolName + ",created=" + this.created.get() + ",destroyed=" + this.destroyed.get() + ",borrowed=" + this.borrowed.get() + ",returned=" + this.returned.get() + ",cleared=" + this.cleared.get() + ",empty=" + this.empty.get() + ",errored=" + this.errored.get() + "}";
        }
    }
}

