/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.graphics.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.imageio.ImageIO;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeatMapImage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HeatMapImage.class);
    private final Map<Integer, LinkedList<Point>> pointsMap = new HashMap<Integer, LinkedList<Point>>();
    private int maxOccurrence = 1;
    private final BufferedImage backgroundImage;
    private final int backgroundWidth;
    private final int backgroundHeight;

    public HeatMapImage(@NotNull BufferedImage backgroundImage, @NotNull Collection<Point> points) {
        this.backgroundImage = backgroundImage;
        this.backgroundWidth = backgroundImage.getWidth();
        this.backgroundHeight = backgroundImage.getHeight();
        for (Point point : points) {
            int hash = this.getKey(point);
            if (this.pointsMap.containsKey(hash)) {
                LinkedList<Point> thisList = this.pointsMap.get(hash);
                thisList.add(point);
                if (thisList.size() <= this.maxOccurrence) continue;
                this.maxOccurrence = thisList.size();
                continue;
            }
            LinkedList<Point> newList = new LinkedList<Point>();
            newList.add(point);
            this.pointsMap.put(hash, newList);
        }
    }

    public BufferedImage createHeatMap(float multiplier, boolean withBackground) {
        BufferedImage circle = this.loadImage("heatmap/heatmap_circle.png");
        if (circle == null) {
            return null;
        }
        BufferedImage heatMap = new BufferedImage(this.backgroundWidth, this.backgroundHeight, 6);
        this.paintInColor(heatMap);
        for (LinkedList<Point> currentPoints : this.pointsMap.values()) {
            float opaque = (float)currentPoints.size() / (float)this.maxOccurrence;
            if ((opaque *= multiplier) > 1.0f) {
                opaque = 1.0f;
            }
            Point currentPoint = currentPoints.get(0);
            this.addImage(heatMap, circle, opaque, currentPoint.x - circle.getWidth() / 2, currentPoint.y - circle.getWidth() / 2);
        }
        this.negateImage(heatMap);
        this.remap(heatMap);
        if (withBackground) {
            BufferedImage output = this.backgroundImage;
            this.addImage(output, heatMap, 0.4f);
            return output;
        }
        return heatMap;
    }

    public void save(String path) {
        try {
            ImageIO.write((RenderedImage)this.createHeatMap(0.3f, true), "png", new File(path));
        }
        catch (IOException e) {
            log.error("Error while saving heat map to path=[{}]", (Object)path, (Object)e);
        }
    }

    private void remap(@NotNull BufferedImage heatMapBW) {
        BufferedImage colorGradiant = this.loadImage("heatmap/heatmap_spectrum.png");
        if (colorGradiant == null) {
            return;
        }
        int width = heatMapBW.getWidth();
        int height = heatMapBW.getHeight();
        int gradientHight = colorGradiant.getHeight() - 1;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int rGB = heatMapBW.getRGB(i, j);
                float multiplier = rGB & 0xFF;
                multiplier *= (float)(rGB >>> 8 & 0xFF);
                multiplier *= (float)(rGB >>> 16 & 0xFF);
                int y = (int)((multiplier /= 1.6581375E7f) * (float)gradientHight);
                int mapedRGB = colorGradiant.getRGB(0, y);
                heatMapBW.setRGB(i, j, mapedRGB);
            }
        }
    }

    private void negateImage(@NotNull BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int rgb = img.getRGB(x, y);
                int r = Math.abs((rgb >>> 16 & 0xFF) - 255);
                int g = Math.abs((rgb >>> 8 & 0xFF) - 255);
                int b = Math.abs((rgb & 0xFF) - 255);
                img.setRGB(x, y, r << 16 | g << 8 | b);
            }
        }
    }

    private void paintInColor(@NotNull BufferedImage buff) {
        Graphics2D g2 = buff.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, buff.getWidth(), buff.getHeight());
        g2.dispose();
    }

    private void addImage(BufferedImage buff1, BufferedImage buff2, float opaque) {
        this.addImage(buff1, buff2, opaque, 0, 0);
    }

    private void addImage(@NotNull BufferedImage buff1, BufferedImage buff2, float opaque, int x, int y) {
        Graphics2D g2d = buff1.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, opaque));
        g2d.drawImage((Image)buff2, x, y, null);
        g2d.dispose();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private BufferedImage loadImage(String fileName) {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fileName);){
            if (inputStream == null) {
                BufferedImage bufferedImage2 = null;
                return bufferedImage2;
            }
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (Exception e) {
            log.error("Error loading image path=[{}]", (Object)fileName, (Object)e);
            return null;
        }
    }

    private int getKey(@NotNull Point point) {
        return point.x << 19 | point.y << 7;
    }
}

