/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.io.binary;

import host.anzo.commons.io.binary.BufferedRandomAccessFile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBinaryReader
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileBinaryReader.class);
    private static final int MAX_NULL_TERMINATED_STRING_LENGTH = 32768;
    private BufferedRandomAccessFile roChannel;

    public FileBinaryReader(String path) {
        this(Paths.get(path, new String[0]), true);
    }

    public FileBinaryReader(String path, boolean castException) {
        this(Paths.get(path, new String[0]), castException);
    }

    public FileBinaryReader(Path path) {
        this(path, true);
    }

    public FileBinaryReader(Path path, boolean castException) {
        block2: {
            this.roChannel = null;
            try {
                this.roChannel = new BufferedRandomAccessFile(path.toString(), "r");
                this.roChannel.order(1);
            }
            catch (Exception ex) {
                if (!castException) break block2;
                log.error("Error while opening FileBinaryReader for file {}", (Object)path.getFileName(), (Object)ex);
            }
        }
    }

    public byte[] readB(int size) throws IOException {
        byte[] temp = new byte[size];
        this.readB(temp);
        return temp;
    }

    public void readB(byte[] dst) throws IOException {
        this.roChannel.read(dst);
    }

    public void readB(byte[] dst, int offset, int len) throws IOException {
        this.roChannel.read(dst, offset, len);
    }

    public int readCD() throws IOException {
        return this.roChannel.readByte() & 0xFF;
    }

    public byte readC() throws IOException {
        return this.roChannel.readByte();
    }

    public boolean readCB() throws IOException {
        return this.readCD() == 1;
    }

    public short readH() throws IOException {
        return (short)(this.roChannel.readShort() & 0xFFFF);
    }

    public int readHD() throws IOException {
        return this.roChannel.readShort() & 0xFFFF;
    }

    public int readD() throws IOException {
        return this.roChannel.readInt();
    }

    public long readDQ() throws IOException {
        return (long)this.roChannel.readInt() & 0xFFFFFFFFL;
    }

    public long readQ() throws IOException {
        return this.roChannel.readLong();
    }

    public int readQD() throws IOException {
        return (int)this.roChannel.readLong();
    }

    public float readF() throws IOException {
        return this.roChannel.readFloat();
    }

    public double readFF() throws IOException {
        return this.roChannel.readDouble();
    }

    public String readS() throws IOException {
        char ch;
        StringBuilder sb = new StringBuilder();
        for (int charCount = 0; charCount < 32768 && (ch = this.roChannel.readChar()) != '\u0000'; ++charCount) {
            sb.append(ch);
        }
        return sb.toString();
    }

    public String readQS() throws IOException {
        return this.readS(this.readQD() * 2);
    }

    @NotNull
    public final String readQSS() throws IOException {
        StringBuilder tb = new StringBuilder();
        for (long size = this.readQ() * 2L; size > 0L; size -= 2L) {
            char c = this.roChannel.readChar();
            if (c == '\u0000') continue;
            tb.append(c);
        }
        return tb.toString();
    }

    public String readS(int size, Charset charset) throws IOException {
        byte[] strBytes = new byte[size];
        this.readB(strBytes);
        return new String(strBytes, charset);
    }

    public String readS(int size) throws IOException {
        return this.readS(size, Charset.defaultCharset());
    }

    public String readS(long size) throws IOException {
        return this.readS((int)size, Charset.defaultCharset());
    }

    public void setPosition(int position) throws IOException {
        this.roChannel.getRandomAccessFile().getChannel().position(position);
    }

    public long getPosition() throws IOException {
        return this.roChannel.getRandomAccessFile().getChannel().position();
    }

    public long getSize() throws IOException {
        return this.roChannel.getRandomAccessFile().getChannel().size();
    }

    public boolean hasFile() {
        return this.roChannel != null;
    }

    public String getPositionHex() throws IOException {
        return Long.toHexString(this.getPosition());
    }

    public final void skip(int bytes) throws IOException {
        this.readB(bytes);
    }

    @Override
    public void close() {
        if (this.roChannel != null) {
            try {
                this.roChannel.close();
            }
            catch (IOException e) {
                log.error("Error while closing FileBinaryReader channel!", (Throwable)e);
            }
        }
    }
}

