/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.threading;

import de.mxro.metrics.jre.Metrics;
import delight.async.properties.PropertyNode;
import host.anzo.commons.emergency.metric.Metric;
import host.anzo.commons.emergency.metric.MetricGroupType;
import host.anzo.commons.emergency.metric.MetricResult;
import host.anzo.core.config.EmergencyConfig;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metric
public class CallableWrapper<V>
implements Callable<V> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CallableWrapper.class);
    private static final PropertyNode CALLABLE_WRAPPER_METRICS = Metrics.create();
    private static final PropertyNode CALLABLE_WRAPPER_METRICS_VIRTUAL = Metrics.create();
    private final Callable<V> _c;
    private final V _dv;
    private final boolean _v;
    private final String _n;

    public CallableWrapper(Callable<V> c, V defaultReturnValue) {
        this(c, defaultReturnValue, false);
    }

    public CallableWrapper(Callable<V> c, V defaultReturnValue, boolean virtual) {
        this(c, defaultReturnValue, virtual, c.getClass().getSimpleName());
    }

    public CallableWrapper(Callable<V> c, V defaultReturnValue, String name) {
        this(c, defaultReturnValue, false, name);
    }

    public CallableWrapper(Callable<V> c, V defaultReturnValue, boolean virtual, String name) {
        this._c = c;
        this._dv = defaultReturnValue;
        this._v = virtual;
        this._n = name != null ? name : c.getClass().getSimpleName();
    }

    @Override
    public V call() throws Exception {
        V result = this._dv;
        if (this._c != null) {
            try {
                if (EmergencyConfig.ENABLE_METRICS) {
                    long start = System.nanoTime();
                    result = this._c.call();
                    this.recordMetric(this._v ? CALLABLE_WRAPPER_METRICS_VIRTUAL : CALLABLE_WRAPPER_METRICS, this._n + "_time_ns", System.nanoTime() - start);
                } else {
                    result = this._c.call();
                }
            }
            catch (Throwable e) {
                this.recordMetric(this._v ? CALLABLE_WRAPPER_METRICS_VIRTUAL : CALLABLE_WRAPPER_METRICS, this._n + "_error");
                log.error("Error while running CallableWrapper:", e);
                throw e;
            }
        }
        return result;
    }

    @NotNull
    public static MetricResult getMetric() {
        MetricResult rw = new MetricResult();
        rw.setMetricGroupType(MetricGroupType.THREADPOOL);
        rw.setName("CallableWrapper");
        rw.setData((String)CALLABLE_WRAPPER_METRICS.render().get());
        return rw;
    }

    public static MetricResult getMetricVirtual() {
        MetricResult rwv = new MetricResult();
        rwv.setMetricGroupType(MetricGroupType.THREADPOOL);
        rwv.setName("CallableWrapperVirtual");
        rwv.setData((String)CALLABLE_WRAPPER_METRICS_VIRTUAL.render().get());
        return rwv;
    }

    private void recordMetric(PropertyNode metrics, String metricName, long value) {
        if (EmergencyConfig.ENABLE_METRICS) {
            metrics.record(Metrics.value((String)metricName, (long)value));
        }
    }

    private void recordMetric(PropertyNode metrics, String metricName) {
        if (EmergencyConfig.ENABLE_METRICS) {
            metrics.record(Metrics.happened((String)metricName));
        }
    }
}

