/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.utils;

import com.sun.management.HotSpotDiagnosticMXBean;
import com.sun.management.VMOption;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VMUtils.class);
    public static boolean DEBUG;
    private static final boolean isZingVM;
    private static HotSpotDiagnosticMXBean hotspotDiagnosticBean;

    public static HotSpotDiagnosticMXBean getBean() {
        return hotspotDiagnosticBean;
    }

    public static VMOption getVMOption(String optionName) {
        return hotspotDiagnosticBean.getVMOption(optionName);
    }

    public static long getDirectBufferFreeMemory() {
        BufferPoolMXBean bufferPool = VMUtils.getByteBufferPool(true);
        if (bufferPool != null) {
            return Long.parseLong(VMUtils.getVMOption("MaxDirectMemorySize").getValue()) - bufferPool.getMemoryUsed();
        }
        return -1L;
    }

    @Nullable
    public static BufferPoolMXBean getByteBufferPool(boolean isDirect) {
        List<BufferPoolMXBean> pools = VMUtils.getByteBufferPools();
        Iterator<BufferPoolMXBean> iterator = pools.iterator();
        if (iterator.hasNext()) {
            BufferPoolMXBean pool = iterator.next();
            if (isDirect && pool.getName().equals("direct")) {
                return pool;
            }
            return pool;
        }
        return null;
    }

    public static List<BufferPoolMXBean> getByteBufferPools() {
        return ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
    }

    private static HotSpotDiagnosticMXBean getHotspotDiagnosticBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            return ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception exp) {
            throw new RuntimeException(exp);
        }
    }

    @NotNull
    public static String getStackTraceString(StackTraceElement @NotNull [] trace) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : trace) {
            sb.append(element.toString()).append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<VMUtils> clazz = VMUtils.class;
        synchronized (VMUtils.class) {
            if (hotspotDiagnosticBean == null) {
                hotspotDiagnosticBean = VMUtils.getHotspotDiagnosticBean();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            isZingVM = System.getProperty("java.vm.version").toLowerCase().contains("zing");
            DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
            log.info("Detected {} JVM (debug={})", (Object)(isZingVM ? "Zing" : "Standard"), (Object)DEBUG);
            return;
        }
    }
}

