package host.anzo.commons.socials.telegram;

import org.jetbrains.annotations.NotNull;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.EditMessageText;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardButton;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.buttons.InlineKeyboardRow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author Aristo
 */
public class TelegramKeyboard {
    private final InlineKeyboardMarkup markup = new InlineKeyboardMarkup(Collections.emptyList());
    private final List<InlineKeyboardRow> keyboard = new ArrayList<>();

    private TelegramKeyboard() {
    }

    public static TelegramKeyboard create() {
        return new TelegramKeyboard();
    }

    public TelegramKeyboard addButton(int row, String text) {
        try {
            while (keyboard.size() <= row) {
                keyboard.add(new InlineKeyboardRow());
            }
            keyboard.get(row).add(InlineKeyboardButton.builder().text(text).callbackData(text).build());
        } catch (Exception ignored) {
        }
        return this;
    }

    public SendMessage attach(@NotNull SendMessage message) {
        markup.setKeyboard(keyboard);
        message.setReplyMarkup(markup);
        return message;
    }

    public EditMessageText attachEdit(@NotNull EditMessageText message) {
        markup.setKeyboard(keyboard);
        message.setReplyMarkup(markup);
        return message;
    }
}