/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.datetime.dailytick;

import host.anzo.commons.utils.DateTimeUtils;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public enum EDailyTickType {
    _12_AM(0),
    _1_AM(1),
    _2_AM(2),
    _3_AM(3),
    _4_AM(4),
    _5_AM(5),
    _6_AM(6),
    _7_AM(7),
    _8_AM(8),
    _9_AM(9),
    _10_AM(10),
    _11_AM(11),
    _12_PM(12),
    _1_PM(13),
    _2_PM(14),
    _3_PM(15),
    _4_PM(16),
    _5_PM(17),
    _6_PM(18),
    _7_PM(19),
    _8_PM(20),
    _9_PM(21),
    _10_PM(22),
    _11_PM(23),
    EVERY_HOUR(-1);

    private final int hour;

    private EDailyTickType(int hour) {
        this.hour = hour;
    }

    public long getTimeToNextTick() {
        if (this == EVERY_HOUR) {
            return DateTimeUtils.getNextHourTime(System.currentTimeMillis()) - System.currentTimeMillis();
        }
        return DateTimeUtils.getNextHourTime(System.currentTimeMillis(), this.getHour()) - System.currentTimeMillis();
    }

    public long getTickPeriod() {
        if (this == EVERY_HOUR) {
            return TimeUnit.HOURS.toMillis(1L);
        }
        return TimeUnit.DAYS.toMillis(1L);
    }

    @Nullable
    public static EDailyTickType valueOfHour(int hour) {
        for (EDailyTickType dailyTickType : EDailyTickType.values()) {
            if (dailyTickType.getHour() != hour) continue;
            return dailyTickType;
        }
        return null;
    }

    @Generated
    public int getHour() {
        return this.hour;
    }
}

