/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.commons.utils;

import java.nio.ByteBuffer;
import org.apache.commons.text.TextStringBuilder;
import org.jetbrains.annotations.NotNull;

public class HexUtils {
    public static byte @NotNull [] stringToHexByteArray(@NotNull String string) {
        String[] stringArray = string.split(" ");
        byte[] bytes = new byte[stringArray.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(stringArray[i], 16);
        }
        return bytes;
    }

    @NotNull
    public static String stringToHexString(@NotNull String string) {
        byte[] chars = string.getBytes();
        return HexUtils.byteArrayToHex(chars);
    }

    @NotNull
    public static String byteArrayToHex(byte @NotNull [] bytes) {
        StringBuilder out = new StringBuilder();
        for (byte c : bytes) {
            out.append(Integer.toHexString(c & 0xFF)).append(" ");
        }
        return out.toString();
    }

    public static byte[] hexStringToByteArray(String str) {
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(str.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static String byteArrayToHexTable(ByteBuffer data, int size) {
        TextStringBuilder result = new TextStringBuilder();
        char[] ascii = new char[17];
        ascii[16] = '\u0000';
        for (int i = 0; i < size; ++i) {
            result.append(String.format("%02X ", data.get(i)));
            ascii[i % 16] = (char)data.get(i) >= ' ' && (char)data.get(i) <= '~' ? (int)data.get(i) : 46;
            if ((i + 1) % 8 != 0 && i + 1 != size) continue;
            result.append(" ");
            if ((i + 1) % 16 == 0) {
                result.append("|  ").appendln(ascii);
                continue;
            }
            if (i + 1 != size) continue;
            ascii[(i + 1) % 16] = '\u0000';
            if ((i + 1) % 16 <= 8) {
                result.append(" ");
            }
            for (int j = (i + 1) % 16; j < 16; ++j) {
                result.append("   ");
            }
            result.append("|  ").appendln(ascii);
        }
        return result.build();
    }

    public static String byteArrayToHexTable(byte[] data) {
        return HexUtils.byteArrayToHexTable(ByteBuffer.wrap(data), data.length);
    }
}

