/*
 * Copyright © 2016 BDO-Emu authors. All rights reserved.
 * Viewing, editing, running and distribution of this software strongly prohibited.
 * Author: xTz, Anton Lasevich, Tibald
 */

package host.anzo.commons.utils;

import lombok.extern.slf4j.Slf4j;

import java.io.IOException;

/**
 * @author ANZO
 * @since 6/30/2023
 */
@Slf4j
public class SystemdUtils {
	public static void notifyReady() {
		notify("--ready");
	}

	public static void setStatus(String status) {
		notify("--status=" + status);
	}

	private static void notify(String param) {
		if (System.getenv("NOTIFY_SOCKET") == null) {
			return;
		}
		try {
			final Process process = new ProcessBuilder("systemd-notify", param)
					.redirectOutput(ProcessBuilder.Redirect.INHERIT)
					.redirectError(ProcessBuilder.Redirect.INHERIT)
					.start();
			final int exitCode = process.waitFor();
			if (exitCode != 0) {
				log.error("Can't notify systemd exitCode={}", exitCode);
			}
		}
		catch (IOException | InterruptedException e) {
			log.error("Can't notify systemd", e);
		}
	}
}