/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.IntByReference;
import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.anticheat.client.callbacks.EOS_AntiCheatClient_OnClientIntegrityViolatedCallback;
import host.anzo.eossdk.eos.sdk.anticheat.client.callbacks.EOS_AntiCheatClient_OnMessageToPeerCallback;
import host.anzo.eossdk.eos.sdk.anticheat.client.callbacks.EOS_AntiCheatClient_OnMessageToServerCallback;
import host.anzo.eossdk.eos.sdk.anticheat.client.callbacks.EOS_AntiCheatClient_OnPeerActionRequiredCallback;
import host.anzo.eossdk.eos.sdk.anticheat.client.callbacks.EOS_AntiCheatClient_OnPeerAuthStatusChangedCallback;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_AddExternalIntegrityCatalogOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_AddNotifyClientIntegrityViolatedOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_AddNotifyMessageToPeerOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_AddNotifyMessageToServerOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_AddNotifyPeerActionRequiredOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_AddNotifyPeerAuthStatusChangedOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_BeginSessionOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_EndSessionOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_GetProtectMessageOutputLengthOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_ProtectMessageOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_ReceiveMessageFromPeerOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_ReceiveMessageFromServerOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_RegisterPeerOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_UnprotectMessageOptions;
import host.anzo.eossdk.eos.sdk.anticheat.client.options.EOS_AntiCheatClient_UnregisterPeerOptions;
import host.anzo.eossdk.eos.sdk.anticheat.common.enums.EOS_EAntiCheatClientMode;
import host.anzo.eossdk.eos.sdk.common.EOS_NotificationId;
import host.anzo.eossdk.eos.sdk.common.EOS_ProductUserId;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.utils.CallbackUtils;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class EOS_AntiCheatClient_Interface
extends PointerType {
    public EOS_AntiCheatClient_Interface(Pointer address) {
        super(address);
    }

    public EOS_AntiCheatClient_Interface() {
    }

    public EOS_NotificationId addNotifyMessageToServer(Pointer clientData, EOS_AntiCheatClient_OnMessageToServerCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_AntiCheatClient_AddNotifyMessageToServer(this, new EOS_AntiCheatClient_AddNotifyMessageToServerOptions(), clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifyMessageToServer(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_AntiCheatClient_RemoveNotifyMessageToServer(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_NotificationId addNotifyMessageToPeer(Pointer clientData, EOS_AntiCheatClient_OnMessageToPeerCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_AntiCheatClient_AddNotifyMessageToPeer(this, new EOS_AntiCheatClient_AddNotifyMessageToPeerOptions(), clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifyMessageToPeer(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_AntiCheatClient_RemoveNotifyMessageToPeer(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_NotificationId addNotifyPeerActionRequired(Pointer clientData, EOS_AntiCheatClient_OnPeerActionRequiredCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_AntiCheatClient_AddNotifyPeerActionRequired(this, new EOS_AntiCheatClient_AddNotifyPeerActionRequiredOptions(), clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifyPeerActionRequired(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_AntiCheatClient_RemoveNotifyPeerActionRequired(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_NotificationId addNotifyPeerAuthStatusChanged(Pointer clientData, EOS_AntiCheatClient_OnPeerAuthStatusChangedCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_AntiCheatClient_AddNotifyPeerAuthStatusChanged(this, new EOS_AntiCheatClient_AddNotifyPeerAuthStatusChangedOptions(), clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifyPeerAuthStatusChanged(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_AntiCheatClient_RemoveNotifyPeerAuthStatusChanged(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_NotificationId addNotifyClientIntegrityViolated(Pointer clientData, EOS_AntiCheatClient_OnClientIntegrityViolatedCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_AntiCheatClient_AddNotifyClientIntegrityViolated(this, new EOS_AntiCheatClient_AddNotifyClientIntegrityViolatedOptions(), clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifyClientIntegrityViolated(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_AntiCheatClient_RemoveNotifyClientIntegrityViolated(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_EResult beginSession(EOS_ProductUserId productUserId, EOS_EAntiCheatClientMode mode) {
        return EOSLibrary.instance.EOS_AntiCheatClient_BeginSession(this, new EOS_AntiCheatClient_BeginSessionOptions(productUserId, mode));
    }

    public EOS_EResult endSession() {
        return EOSLibrary.instance.EOS_AntiCheatClient_EndSession(this, new EOS_AntiCheatClient_EndSessionOptions());
    }

    public EOS_EResult addExternalIntegrityCatalog(EOS_AntiCheatClient_AddExternalIntegrityCatalogOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatClient_AddExternalIntegrityCatalog(this, options);
    }

    public EOS_EResult receiveMessageFromServer(EOS_AntiCheatClient_ReceiveMessageFromServerOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatClient_ReceiveMessageFromServer(this, options);
    }

    public int getProtectMessageOutputLength(int dataSize) throws EOSException {
        IntByReference sizeBytesReference = new IntByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_AntiCheatClient_GetProtectMessageOutputLength(this, new EOS_AntiCheatClient_GetProtectMessageOutputLengthOptions(dataSize), sizeBytesReference);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return sizeBytesReference.getValue();
    }

    public ByteBuffer protectMessage(byte @NotNull [] data, int outBufferSizeBytes) throws EOSException {
        IntByReference outBytesWritten;
        EOS_AntiCheatClient_ProtectMessageOptions.ByReference options = new EOS_AntiCheatClient_ProtectMessageOptions.ByReference(data, outBufferSizeBytes);
        ByteBuffer outBuffer = ByteBuffer.allocate(outBufferSizeBytes);
        EOS_EResult result = EOSLibrary.instance.EOS_AntiCheatClient_ProtectMessage(this, options, outBuffer, outBytesWritten = new IntByReference());
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return outBuffer;
    }

    public ByteBuffer unprotectMessage(byte[] data) throws EOSException {
        EOS_AntiCheatClient_UnprotectMessageOptions.ByReference options = new EOS_AntiCheatClient_UnprotectMessageOptions.ByReference(data);
        IntByReference outBytesWritten = new IntByReference();
        ByteBuffer outBuffer = ByteBuffer.allocate(data.length);
        EOS_EResult result = EOSLibrary.instance.EOS_AntiCheatClient_UnprotectMessage(this, options, outBuffer, outBytesWritten);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        outBuffer.limit(outBytesWritten.getValue());
        return outBuffer;
    }

    public EOS_EResult registerPeer(EOS_AntiCheatClient_RegisterPeerOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatClient_RegisterPeer(this, options);
    }

    public EOS_EResult unregisterPeer(EOS_AntiCheatClient_UnregisterPeerOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatClient_UnregisterPeer(this, options);
    }

    public EOS_EResult receiveMessageFromPeer(EOS_AntiCheatClient_ReceiveMessageFromPeerOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatClient_ReceiveMessageFromPeer(this, options);
    }
}

