/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.IntByReference;
import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.common.EOS_Bool;
import host.anzo.eossdk.eos.sdk.common.EOS_NotificationId;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.sdk.presence.EOS_PresenceModification;
import host.anzo.eossdk.eos.sdk.presence.EOS_Presence_Info;
import host.anzo.eossdk.eos.sdk.presence.callbacks.EOS_Presence_OnJoinGameAcceptedCallback;
import host.anzo.eossdk.eos.sdk.presence.callbacks.EOS_Presence_OnPresenceChangedCallback;
import host.anzo.eossdk.eos.sdk.presence.callbacks.EOS_Presence_OnQueryPresenceCompleteCallback;
import host.anzo.eossdk.eos.sdk.presence.callbacks.EOS_Presence_SetPresenceCompleteCallback;
import host.anzo.eossdk.eos.sdk.presence.options.EOS_Presence_AddNotifyJoinGameAcceptedOptions;
import host.anzo.eossdk.eos.sdk.presence.options.EOS_Presence_AddNotifyOnPresenceChangedOptions;
import host.anzo.eossdk.eos.sdk.presence.options.EOS_Presence_CopyPresenceOptions;
import host.anzo.eossdk.eos.sdk.presence.options.EOS_Presence_CreatePresenceModificationOptions;
import host.anzo.eossdk.eos.sdk.presence.options.EOS_Presence_GetJoinInfoOptions;
import host.anzo.eossdk.eos.sdk.presence.options.EOS_Presence_HasPresenceOptions;
import host.anzo.eossdk.eos.sdk.presence.options.EOS_Presence_QueryPresenceOptions;
import host.anzo.eossdk.eos.sdk.presence.options.EOS_Presence_SetPresenceOptions;
import host.anzo.eossdk.eos.utils.CallbackUtils;

public class EOS_Presence_Interface
extends PointerType {
    public EOS_Presence_Interface(Pointer address) {
        super(address);
    }

    public EOS_Presence_Interface() {
    }

    public void queryPresence(EOS_Presence_QueryPresenceOptions options, Pointer clientData, EOS_Presence_OnQueryPresenceCompleteCallback completionDelegate) {
        EOSLibrary.instance.EOS_Presence_QueryPresence(this, options, clientData, completionDelegate);
    }

    public boolean hasPresence(EOS_Presence_HasPresenceOptions options) {
        return EOSLibrary.instance.EOS_Presence_HasPresence(this, options) == EOS_Bool.EOS_TRUE;
    }

    public EOS_Presence_Info copyPresence(EOS_Presence_CopyPresenceOptions options) throws EOSException {
        EOS_Presence_Info.ByReference outPresence = new EOS_Presence_Info.ByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_Presence_CopyPresence(this, options, outPresence);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return outPresence;
    }

    public EOS_EResult createPresenceModification(EOS_Presence_CreatePresenceModificationOptions options, EOS_PresenceModification outPresenceModificationHandle) {
        return EOSLibrary.instance.EOS_Presence_CreatePresenceModification(this, options, outPresenceModificationHandle);
    }

    public void setPresence(EOS_Presence_SetPresenceOptions options, Pointer clientData, EOS_Presence_SetPresenceCompleteCallback completionDelegate) {
        EOSLibrary.instance.EOS_Presence_SetPresence(this, options, clientData, completionDelegate);
    }

    public EOS_NotificationId addNotifyOnPresenceChanged(EOS_Presence_AddNotifyOnPresenceChangedOptions options, Pointer clientData, EOS_Presence_OnPresenceChangedCallback notificationHandler) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_Presence_AddNotifyOnPresenceChanged(this, options, clientData, notificationHandler);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationHandler);
        }
        return notificationId;
    }

    public void removeNotifyOnPresenceChanged(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_Presence_RemoveNotifyOnPresenceChanged(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_NotificationId addNotifyJoinGameAccepted(EOS_Presence_AddNotifyJoinGameAcceptedOptions options, Pointer clientData, EOS_Presence_OnJoinGameAcceptedCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_Presence_AddNotifyJoinGameAccepted(this, options, clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifyJoinGameAccepted(EOS_NotificationId inId) {
        EOSLibrary.instance.EOS_Presence_RemoveNotifyJoinGameAccepted(this, inId);
        CallbackUtils.unregisterNotificationCallback(inId);
    }

    public String getJoinInfo(EOS_Presence_GetJoinInfoOptions options) throws EOSException {
        byte[] outBuffer = new byte[255];
        IntByReference inOutBufferLength = new IntByReference(255);
        EOS_EResult result = EOSLibrary.instance.EOS_Presence_GetJoinInfo(this, options, outBuffer, inOutBufferLength);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return new String(outBuffer, 0, inOutBufferLength.getValue());
    }
}

