/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk.common;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.IntByReference;
import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.common.EOS_Bool;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import java.nio.ByteBuffer;

public class EOS_EpicAccountId
extends PointerType {
    public static int EOS_EPICACCOUNTID_MAX_LENGTH = 32;

    public EOS_EpicAccountId(Pointer address) {
        super(address);
    }

    public EOS_EpicAccountId() {
    }

    public static EOS_EpicAccountId fromString(String accountIdString) {
        return EOSLibrary.instance.EOS_EpicAccountId_FromString(accountIdString);
    }

    public boolean isValid() {
        return EOSLibrary.instance.EOS_EpicAccountId_IsValid(this) == EOS_Bool.EOS_TRUE;
    }

    public String getString() throws EOSException {
        IntByReference inOutBufferLength;
        ByteBuffer outBuffer = ByteBuffer.allocate(EOS_EPICACCOUNTID_MAX_LENGTH + 1);
        EOS_EResult result = EOSLibrary.instance.EOS_EpicAccountId_ToString(this, outBuffer, inOutBufferLength = new IntByReference(outBuffer.capacity()));
        if (result.isSuccess()) {
            return new String(outBuffer.array(), 0, inOutBufferLength.getValue()).trim();
        }
        throw EOSException.fromResult(result);
    }
}

