/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.common.EOS_NotificationId;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.sdk.kws.EOS_KWS_PermissionStatus;
import host.anzo.eossdk.eos.sdk.kws.callbacks.EOS_KWS_OnCreateUserCallback;
import host.anzo.eossdk.eos.sdk.kws.callbacks.EOS_KWS_OnPermissionsUpdateReceivedCallback;
import host.anzo.eossdk.eos.sdk.kws.callbacks.EOS_KWS_OnQueryAgeGateCallback;
import host.anzo.eossdk.eos.sdk.kws.callbacks.EOS_KWS_OnQueryPermissionsCallback;
import host.anzo.eossdk.eos.sdk.kws.callbacks.EOS_KWS_OnRequestPermissionsCallback;
import host.anzo.eossdk.eos.sdk.kws.callbacks.EOS_KWS_OnUpdateParentEmailCallback;
import host.anzo.eossdk.eos.sdk.kws.options.EOS_KWS_AddNotifyPermissionsUpdateReceivedOptions;
import host.anzo.eossdk.eos.sdk.kws.options.EOS_KWS_CopyPermissionByIndexOptions;
import host.anzo.eossdk.eos.sdk.kws.options.EOS_KWS_CreateUserOptions;
import host.anzo.eossdk.eos.sdk.kws.options.EOS_KWS_GetPermissionByKeyOptions;
import host.anzo.eossdk.eos.sdk.kws.options.EOS_KWS_GetPermissionsCountOptions;
import host.anzo.eossdk.eos.sdk.kws.options.EOS_KWS_QueryAgeGateOptions;
import host.anzo.eossdk.eos.sdk.kws.options.EOS_KWS_QueryPermissionsOptions;
import host.anzo.eossdk.eos.sdk.kws.options.EOS_KWS_RequestPermissionsOptions;
import host.anzo.eossdk.eos.sdk.kws.options.EOS_KWS_UpdateParentEmailOptions;
import host.anzo.eossdk.eos.utils.CallbackUtils;
import java.nio.IntBuffer;

public class EOS_KWS_Interface
extends PointerType {
    public EOS_KWS_Interface(Pointer address) {
        super(address);
    }

    public EOS_KWS_Interface() {
    }

    public void queryAgeGate(EOS_KWS_QueryAgeGateOptions options, Pointer clientData, EOS_KWS_OnQueryAgeGateCallback completionDelegate) {
        EOSLibrary.instance.EOS_KWS_QueryAgeGate(this, options, clientData, completionDelegate);
    }

    public void createUser(EOS_KWS_CreateUserOptions options, Pointer clientData, EOS_KWS_OnCreateUserCallback completionDelegate) {
        EOSLibrary.instance.EOS_KWS_CreateUser(this, options, clientData, completionDelegate);
    }

    public void queryPermissions(EOS_KWS_QueryPermissionsOptions options, Pointer clientData, EOS_KWS_OnQueryPermissionsCallback completionDelegate) {
        EOSLibrary.instance.EOS_KWS_QueryPermissions(this, options, clientData, completionDelegate);
    }

    public void updateParentEmail(EOS_KWS_UpdateParentEmailOptions options, Pointer clientData, EOS_KWS_OnUpdateParentEmailCallback completionDelegate) {
        EOSLibrary.instance.EOS_KWS_UpdateParentEmail(this, options, clientData, completionDelegate);
    }

    public void requestPermissions(EOS_KWS_RequestPermissionsOptions options, Pointer clientData, EOS_KWS_OnRequestPermissionsCallback completionDelegate) {
        EOSLibrary.instance.EOS_KWS_RequestPermissions(this, options, clientData, completionDelegate);
    }

    public int getPermissionsCount(EOS_KWS_GetPermissionsCountOptions options) {
        return EOSLibrary.instance.EOS_KWS_GetPermissionsCount(this, options);
    }

    public EOS_KWS_PermissionStatus copyPermissionByIndex(EOS_KWS_CopyPermissionByIndexOptions options) throws EOSException {
        EOS_KWS_PermissionStatus.ByReference outPermission = new EOS_KWS_PermissionStatus.ByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_KWS_CopyPermissionByIndex(this, options, outPermission);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return outPermission;
    }

    public EOS_EResult getPermissionByKey(EOS_KWS_GetPermissionByKeyOptions options, IntBuffer outPermission) {
        return EOSLibrary.instance.EOS_KWS_GetPermissionByKey(this, options, outPermission);
    }

    public EOS_NotificationId addNotifyPermissionsUpdateReceived(EOS_KWS_AddNotifyPermissionsUpdateReceivedOptions options, Pointer clientData, EOS_KWS_OnPermissionsUpdateReceivedCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_KWS_AddNotifyPermissionsUpdateReceived(this, options, clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifyPermissionsUpdateReceived(EOS_NotificationId inId) {
        EOSLibrary.instance.EOS_KWS_RemoveNotifyPermissionsUpdateReceived(this, inId);
        CallbackUtils.unregisterNotificationCallback(inId);
    }
}

