/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.ShortByReference;
import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.common.EOS_NotificationId;
import host.anzo.eossdk.eos.sdk.common.EOS_ProductUserId;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.sdk.p2p.EOS_P2P_PacketQueueInfo;
import host.anzo.eossdk.eos.sdk.p2p.EOS_P2P_SocketId;
import host.anzo.eossdk.eos.sdk.p2p.callbacks.EOS_P2P_OnIncomingConnectionRequestCallback;
import host.anzo.eossdk.eos.sdk.p2p.callbacks.EOS_P2P_OnIncomingPacketQueueFullCallback;
import host.anzo.eossdk.eos.sdk.p2p.callbacks.EOS_P2P_OnPeerConnectionEstablishedCallback;
import host.anzo.eossdk.eos.sdk.p2p.callbacks.EOS_P2P_OnPeerConnectionInterruptedCallback;
import host.anzo.eossdk.eos.sdk.p2p.callbacks.EOS_P2P_OnQueryNATTypeCompleteCallback;
import host.anzo.eossdk.eos.sdk.p2p.callbacks.EOS_P2P_OnRemoteConnectionClosedCallback;
import host.anzo.eossdk.eos.sdk.p2p.enums.EOS_ENATType;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_AcceptConnectionOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_AddNotifyIncomingPacketQueueFullOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_AddNotifyPeerConnectionClosedOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_AddNotifyPeerConnectionEstablishedOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_AddNotifyPeerConnectionInterruptedOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_AddNotifyPeerConnectionRequestOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_ClearPacketQueueOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_CloseConnectionOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_CloseConnectionsOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_GetNATTypeOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_GetNextReceivedPacketSizeOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_GetPacketQueueInfoOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_GetPortRangeOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_GetRelayControlOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_QueryNATTypeOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_ReceivePacketOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_SendPacketOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_SetPacketQueueSizeOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_SetPortRangeOptions;
import host.anzo.eossdk.eos.sdk.p2p.options.EOS_P2P_SetRelayControlOptions;
import host.anzo.eossdk.eos.utils.CallbackUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class EOS_P2P_Interface
extends PointerType {
    public EOS_P2P_Interface(Pointer address) {
        super(address);
    }

    public EOS_P2P_Interface() {
    }

    public EOS_EResult sendPacket(EOS_P2P_SendPacketOptions options) {
        return EOSLibrary.instance.EOS_P2P_SendPacket(this, options);
    }

    public EOS_EResult getNextReceivedPacketSize(EOS_P2P_GetNextReceivedPacketSizeOptions options, IntBuffer outPacketSizeBytes) {
        return EOSLibrary.instance.EOS_P2P_GetNextReceivedPacketSize(this, options, outPacketSizeBytes);
    }

    public EOS_EResult receivePacket(EOS_P2P_ReceivePacketOptions options, EOS_ProductUserId outPeerId, EOS_P2P_SocketId outSocketId, ByteBuffer outChannel, Pointer outData, IntBuffer outBytesWritten) {
        return EOSLibrary.instance.EOS_P2P_ReceivePacket(this, options, outPeerId, outSocketId, outChannel, outData, outBytesWritten);
    }

    public EOS_NotificationId addNotifyPeerConnectionRequest(EOS_P2P_AddNotifyPeerConnectionRequestOptions options, Pointer clientData, EOS_P2P_OnIncomingConnectionRequestCallback connectionRequestHandler) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_P2P_AddNotifyPeerConnectionRequest(this, options, clientData, connectionRequestHandler);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, connectionRequestHandler);
        }
        return notificationId;
    }

    public void removeNotifyPeerConnectionRequest(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_P2P_RemoveNotifyPeerConnectionRequest(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_NotificationId addNotifyPeerConnectionEstablished(EOS_P2P_AddNotifyPeerConnectionEstablishedOptions options, Pointer clientData, EOS_P2P_OnPeerConnectionEstablishedCallback connectionEstablishedHandler) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_P2P_AddNotifyPeerConnectionEstablished(this, options, clientData, connectionEstablishedHandler);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, connectionEstablishedHandler);
        }
        return notificationId;
    }

    public void removeNotifyPeerConnectionEstablished(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_P2P_RemoveNotifyPeerConnectionEstablished(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_NotificationId addNotifyPeerConnectionInterrupted(EOS_P2P_AddNotifyPeerConnectionInterruptedOptions options, Pointer clientData, EOS_P2P_OnPeerConnectionInterruptedCallback connectionInterruptedHandler) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_P2P_AddNotifyPeerConnectionInterrupted(this, options, clientData, connectionInterruptedHandler);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, connectionInterruptedHandler);
        }
        return notificationId;
    }

    public void removeNotifyPeerConnectionInterrupted(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_P2P_RemoveNotifyPeerConnectionInterrupted(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_NotificationId addNotifyPeerConnectionClosed(EOS_P2P_AddNotifyPeerConnectionClosedOptions options, Pointer clientData, EOS_P2P_OnRemoteConnectionClosedCallback connectionClosedHandler) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_P2P_AddNotifyPeerConnectionClosed(this, options, clientData, connectionClosedHandler);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, connectionClosedHandler);
        }
        return notificationId;
    }

    public void removeNotifyPeerConnectionClosed(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_P2P_RemoveNotifyPeerConnectionClosed(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_EResult acceptConnection(EOS_P2P_AcceptConnectionOptions options) {
        return EOSLibrary.instance.EOS_P2P_AcceptConnection(this, options);
    }

    public EOS_EResult closeConnection(EOS_P2P_CloseConnectionOptions options) {
        return EOSLibrary.instance.EOS_P2P_CloseConnection(this, options);
    }

    public EOS_EResult closeConnections(EOS_P2P_CloseConnectionsOptions options) {
        return EOSLibrary.instance.EOS_P2P_CloseConnections(this, options);
    }

    public void queryNATType(EOS_P2P_QueryNATTypeOptions options, Pointer clientData, EOS_P2P_OnQueryNATTypeCompleteCallback completionDelegate) {
        EOSLibrary.instance.EOS_P2P_QueryNATType(this, options, clientData, completionDelegate);
    }

    public EOS_ENATType getNATType(EOS_P2P_GetNATTypeOptions options) throws EOSException {
        IntByReference outNATType = new IntByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_P2P_GetNATType(this, options, outNATType);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return EOS_ENATType.fromId(outNATType.getValue());
    }

    public EOS_EResult setRelayControl(EOS_P2P_SetRelayControlOptions options) {
        return EOSLibrary.instance.EOS_P2P_SetRelayControl(this, options);
    }

    public EOS_EResult getRelayControl(EOS_P2P_GetRelayControlOptions options, IntBuffer outRelayControl) {
        return EOSLibrary.instance.EOS_P2P_GetRelayControl(this, options, outRelayControl);
    }

    public EOS_EResult setPortRange(EOS_P2P_SetPortRangeOptions options) {
        return EOSLibrary.instance.EOS_P2P_SetPortRange(this, options);
    }

    public EOS_EResult getPortRange(EOS_P2P_GetPortRangeOptions options, ShortByReference outPort, ShortByReference outNumAdditionalPortsToTry) {
        return EOSLibrary.instance.EOS_P2P_GetPortRange(this, options, outPort, outNumAdditionalPortsToTry);
    }

    public EOS_EResult setPacketQueueSize(EOS_P2P_SetPacketQueueSizeOptions options) {
        return EOSLibrary.instance.EOS_P2P_SetPacketQueueSize(this, options);
    }

    public EOS_P2P_PacketQueueInfo getPacketQueueInfo(EOS_P2P_GetPacketQueueInfoOptions options) throws EOSException {
        EOS_P2P_PacketQueueInfo.ByReference outPacketQueueInfo = new EOS_P2P_PacketQueueInfo.ByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_P2P_GetPacketQueueInfo(this, options, outPacketQueueInfo);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return outPacketQueueInfo;
    }

    public EOS_NotificationId addNotifyIncomingPacketQueueFull(EOS_P2P_AddNotifyIncomingPacketQueueFullOptions options, Pointer clientData, EOS_P2P_OnIncomingPacketQueueFullCallback incomingPacketQueueFullHandler) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_P2P_AddNotifyIncomingPacketQueueFull(this, options, clientData, incomingPacketQueueFullHandler);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, incomingPacketQueueFullHandler);
        }
        return notificationId;
    }

    public void removeNotifyIncomingPacketQueueFull(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_P2P_RemoveNotifyIncomingPacketQueueFull(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_EResult clearPacketQueue(EOS_P2P_ClearPacketQueueOptions options) {
        return EOSLibrary.instance.EOS_P2P_ClearPacketQueue(this, options);
    }
}

