/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.IntByReference;
import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.common.EOS_NotificationId;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.sdk.sessions.EOS_ActiveSession;
import host.anzo.eossdk.eos.sdk.sessions.EOS_SessionDetails;
import host.anzo.eossdk.eos.sdk.sessions.EOS_SessionModification;
import host.anzo.eossdk.eos.sdk.sessions.EOS_SessionSearch;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnDestroySessionCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnEndSessionCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnJoinSessionAcceptedCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnJoinSessionCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnLeaveSessionRequestedCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnQueryInvitesCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnRegisterPlayersCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnRejectInviteCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnSendInviteCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnSendSessionNativeInviteRequestedCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnSessionInviteAcceptedCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnSessionInviteReceivedCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnSessionInviteRejectedCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnStartSessionCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnUnregisterPlayersCallback;
import host.anzo.eossdk.eos.sdk.sessions.callbacks.EOS_Sessions_OnUpdateSessionCallback;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_AddNotifyJoinSessionAcceptedOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_AddNotifyLeaveSessionRequestedOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_AddNotifySendSessionNativeInviteRequestedOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_AddNotifySessionInviteAcceptedOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_AddNotifySessionInviteReceivedOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_AddNotifySessionInviteRejectedOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_CopyActiveSessionHandleOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_CopySessionHandleByInviteIdOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_CopySessionHandleByUiEventIdOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_CopySessionHandleForPresenceOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_CreateSessionModificationOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_CreateSessionSearchOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_DestroySessionOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_DumpSessionStateOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_EndSessionOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_GetInviteCountOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_GetInviteIdByIndexOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_IsUserInSessionOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_JoinSessionOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_QueryInvitesOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_RegisterPlayersOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_RejectInviteOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_SendInviteOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_StartSessionOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_UnregisterPlayersOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_UpdateSessionModificationOptions;
import host.anzo.eossdk.eos.sdk.sessions.options.EOS_Sessions_UpdateSessionOptions;
import host.anzo.eossdk.eos.utils.CallbackUtils;

public class EOS_Sessions_Interface
extends PointerType {
    public static final int EOS_SESSIONS_INVITEID_MAX_LENGTH = 64;

    public EOS_Sessions_Interface(Pointer address) {
        super(address);
    }

    public EOS_Sessions_Interface() {
    }

    public EOS_EResult createSessionModification(EOS_Sessions_CreateSessionModificationOptions options, EOS_SessionModification outSessionModificationHandle) {
        return EOSLibrary.instance.EOS_Sessions_CreateSessionModification(this, options, outSessionModificationHandle);
    }

    public EOS_EResult updateSessionModification(EOS_Sessions_UpdateSessionModificationOptions options, EOS_SessionModification outSessionModificationHandle) {
        return EOSLibrary.instance.EOS_Sessions_UpdateSessionModification(this, options, outSessionModificationHandle);
    }

    public void updateSession(EOS_Sessions_UpdateSessionOptions options, Pointer clientData, EOS_Sessions_OnUpdateSessionCallback completionDelegate) {
        EOSLibrary.instance.EOS_Sessions_UpdateSession(this, options, clientData, completionDelegate);
    }

    public void destroySession(EOS_Sessions_DestroySessionOptions options, Pointer clientData, EOS_Sessions_OnDestroySessionCallback completionDelegate) {
        EOSLibrary.instance.EOS_Sessions_DestroySession(this, options, clientData, completionDelegate);
    }

    public void joinSession(EOS_Sessions_JoinSessionOptions options, Pointer clientData, EOS_Sessions_OnJoinSessionCallback completionDelegate) {
        EOSLibrary.instance.EOS_Sessions_JoinSession(this, options, clientData, completionDelegate);
    }

    public void startSession(EOS_Sessions_StartSessionOptions options, Pointer clientData, EOS_Sessions_OnStartSessionCallback completionDelegate) {
        EOSLibrary.instance.EOS_Sessions_StartSession(this, options, clientData, completionDelegate);
    }

    public void endSession(EOS_Sessions_EndSessionOptions options, Pointer clientData, EOS_Sessions_OnEndSessionCallback completionDelegate) {
        EOSLibrary.instance.EOS_Sessions_EndSession(this, options, clientData, completionDelegate);
    }

    public void registerPlayers(EOS_Sessions_RegisterPlayersOptions options, Pointer clientData, EOS_Sessions_OnRegisterPlayersCallback completionDelegate) {
        EOSLibrary.instance.EOS_Sessions_RegisterPlayers(this, options, clientData, completionDelegate);
    }

    public void unregisterPlayers(EOS_Sessions_UnregisterPlayersOptions options, Pointer clientData, EOS_Sessions_OnUnregisterPlayersCallback completionDelegate) {
        EOSLibrary.instance.EOS_Sessions_UnregisterPlayers(this, options, clientData, completionDelegate);
    }

    public void sendInvite(EOS_Sessions_SendInviteOptions options, Pointer clientData, EOS_Sessions_OnSendInviteCallback completionDelegate) {
        EOSLibrary.instance.EOS_Sessions_SendInvite(this, options, clientData, completionDelegate);
    }

    public void rejectInvite(EOS_Sessions_RejectInviteOptions options, Pointer clientData, EOS_Sessions_OnRejectInviteCallback completionDelegate) {
        EOSLibrary.instance.EOS_Sessions_RejectInvite(this, options, clientData, completionDelegate);
    }

    public void queryInvites(EOS_Sessions_QueryInvitesOptions options, Pointer clientData, EOS_Sessions_OnQueryInvitesCallback completionDelegate) {
        EOSLibrary.instance.EOS_Sessions_QueryInvites(this, options, clientData, completionDelegate);
    }

    public int getInviteCount(EOS_Sessions_GetInviteCountOptions options) {
        return EOSLibrary.instance.EOS_Sessions_GetInviteCount(this, options);
    }

    public String getInviteIdByIndex(EOS_Sessions_GetInviteIdByIndexOptions options) throws EOSException {
        byte[] outBuffer = new byte[64];
        IntByReference inOutBufferLength = new IntByReference(64);
        EOS_EResult result = EOSLibrary.instance.EOS_Sessions_GetInviteIdByIndex(this, options, outBuffer, inOutBufferLength);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return new String(outBuffer, 0, inOutBufferLength.getValue());
    }

    public EOS_EResult createSessionSearch(EOS_Sessions_CreateSessionSearchOptions options, EOS_SessionSearch outSessionSearchHandle) {
        return EOSLibrary.instance.EOS_Sessions_CreateSessionSearch(this, options, outSessionSearchHandle);
    }

    public EOS_EResult copyActiveSessionHandle(EOS_Sessions_CopyActiveSessionHandleOptions options, EOS_ActiveSession outSessionHandle) {
        return EOSLibrary.instance.EOS_Sessions_CopyActiveSessionHandle(this, options, outSessionHandle);
    }

    public EOS_NotificationId addNotifySessionInviteReceived(EOS_Sessions_AddNotifySessionInviteReceivedOptions options, Pointer clientData, EOS_Sessions_OnSessionInviteReceivedCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_Sessions_AddNotifySessionInviteReceived(this, options, clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifySessionInviteReceived(EOS_NotificationId inId) {
        EOSLibrary.instance.EOS_Sessions_RemoveNotifySessionInviteReceived(this, inId);
        CallbackUtils.unregisterNotificationCallback(inId);
    }

    public EOS_NotificationId addNotifySessionInviteAccepted(EOS_Sessions_AddNotifySessionInviteAcceptedOptions options, Pointer clientData, EOS_Sessions_OnSessionInviteAcceptedCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_Sessions_AddNotifySessionInviteAccepted(this, options, clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifySessionInviteAccepted(EOS_NotificationId inId) {
        EOSLibrary.instance.EOS_Sessions_RemoveNotifySessionInviteAccepted(this, inId);
        CallbackUtils.unregisterNotificationCallback(inId);
    }

    public EOS_NotificationId addNotifySessionInviteRejected(EOS_Sessions_AddNotifySessionInviteRejectedOptions options, Pointer clientData, EOS_Sessions_OnSessionInviteRejectedCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_Sessions_AddNotifySessionInviteRejected(this, options, clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifySessionInviteRejected(EOS_NotificationId inId) {
        EOSLibrary.instance.EOS_Sessions_RemoveNotifySessionInviteRejected(this, inId);
        CallbackUtils.unregisterNotificationCallback(inId);
    }

    public EOS_NotificationId addNotifyJoinSessionAccepted(EOS_Sessions_AddNotifyJoinSessionAcceptedOptions options, Pointer clientData, EOS_Sessions_OnJoinSessionAcceptedCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_Sessions_AddNotifyJoinSessionAccepted(this, options, clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifyJoinSessionAccepted(EOS_NotificationId inId) {
        EOSLibrary.instance.EOS_Sessions_RemoveNotifyJoinSessionAccepted(this, inId);
        CallbackUtils.unregisterNotificationCallback(inId);
    }

    public EOS_EResult copySessionHandleByInviteId(EOS_Sessions_CopySessionHandleByInviteIdOptions options, EOS_SessionDetails outSessionHandle) {
        return EOSLibrary.instance.EOS_Sessions_CopySessionHandleByInviteId(this, options, outSessionHandle);
    }

    public EOS_EResult copySessionHandleByUiEventId(EOS_Sessions_CopySessionHandleByUiEventIdOptions options, EOS_SessionDetails outSessionHandle) {
        return EOSLibrary.instance.EOS_Sessions_CopySessionHandleByUiEventId(this, options, outSessionHandle);
    }

    public EOS_EResult copySessionHandleForPresence(EOS_Sessions_CopySessionHandleForPresenceOptions options, EOS_SessionDetails outSessionHandle) {
        return EOSLibrary.instance.EOS_Sessions_CopySessionHandleForPresence(this, options, outSessionHandle);
    }

    public EOS_EResult isUserInSession(EOS_Sessions_IsUserInSessionOptions options) {
        return EOSLibrary.instance.EOS_Sessions_IsUserInSession(this, options);
    }

    public EOS_EResult dumpSessionState(EOS_Sessions_DumpSessionStateOptions options) {
        return EOSLibrary.instance.EOS_Sessions_DumpSessionState(this, options);
    }

    public EOS_NotificationId addNotifyLeaveSessionRequested(EOS_Sessions_AddNotifyLeaveSessionRequestedOptions options, Pointer clientData, EOS_Sessions_OnLeaveSessionRequestedCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_Sessions_AddNotifyLeaveSessionRequested(this, options, clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifyLeaveSessionRequested(EOS_NotificationId inId) {
        EOSLibrary.instance.EOS_Sessions_RemoveNotifyLeaveSessionRequested(this, inId);
        CallbackUtils.unregisterNotificationCallback(inId);
    }

    public EOS_NotificationId addNotifySendSessionNativeInviteRequested(EOS_Sessions_AddNotifySendSessionNativeInviteRequestedOptions options, Pointer clientData, EOS_Sessions_OnSendSessionNativeInviteRequestedCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_Sessions_AddNotifySendSessionNativeInviteRequested(this, options, clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifySendSessionNativeInviteRequested(EOS_NotificationId inId) {
        EOSLibrary.instance.EOS_Sessions_RemoveNotifySendSessionNativeInviteRequested(this, inId);
        CallbackUtils.unregisterNotificationCallback(inId);
    }
}

