/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eosex;

import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOS;
import host.anzo.eossdk.eos.sdk.EOS_Logging_Interface;
import host.anzo.eossdk.eos.sdk.EOS_Platform_Interface;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.sdk.init.options.EOS_InitializeOptions;
import host.anzo.eossdk.eos.sdk.logging.EOS_LogMessage;
import host.anzo.eossdk.eos.sdk.platform.options.EOS_Platform_Options;
import host.anzo.eossdk.eos.sdk.reports.enums.EOS_EPlayerReportsCategory;
import host.anzo.eossdk.eos.sdk.reports.options.EOS_Reports_SendPlayerBehaviorReportOptions;
import host.anzo.eossdk.eosex.EOSBaseOptions;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AEOSBase<T extends EOSBaseOptions> {
    private static final Logger log = LoggerFactory.getLogger(AEOSBase.class);
    protected T options;
    protected EOS_Platform_Interface platform;
    private static final ScheduledExecutorService taskExecutor = Executors.newScheduledThreadPool(1);

    public AEOSBase<T> start(T baseOptions) throws EOSException {
        this.options = baseOptions;
        this.callApiSync(this::initPlatform);
        return this;
    }

    public void shutdown() {
        try {
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while taskExecutor termination", e);
        }
        this.platform.release();
        EOS.EOS_Shutdown();
    }

    protected void initPlatform() {
        EOS_EResult initResult = EOS.EOS_Initialize(new EOS_InitializeOptions((EOSBaseOptions)this.options));
        if (!initResult.isSuccess()) {
            throw new RuntimeException("Failed to EOS_Initialize with message: " + (Object)((Object)initResult));
        }
        EOS_EResult setLogCallbackResult = EOS_Logging_Interface.setCallback(this::onLogMessage);
        if (!setLogCallbackResult.isSuccess()) {
            throw new RuntimeException("Failed to EOS_Logging_SetCallback with message: " + (Object)((Object)setLogCallbackResult));
        }
        EOS_EResult setLogLevelResult = EOS_Logging_Interface.setLogLevel(((EOSBaseOptions)this.options).getLogCategory(), ((EOSBaseOptions)this.options).getLogLevel());
        if (!setLogLevelResult.isSuccess()) {
            throw new RuntimeException("Failed to EOS_Logging_SetLogLevel with message: " + (Object)((Object)setLogLevelResult));
        }
        this.platform = EOS.EOS_Platform_Create(new EOS_Platform_Options((EOSBaseOptions)this.options));
        if (this.platform == null) {
            throw new RuntimeException("Failed to EOS_Platform_Create: pointer is null");
        }
        taskExecutor.scheduleAtFixedRate(() -> this.platform.tick(), 0L, ((EOSBaseOptions)this.options).getTickPeriod(), TimeUnit.MILLISECONDS);
    }

    protected void callApi(Runnable runnable) {
        taskExecutor.execute(runnable);
    }

    protected void callApiSync(Runnable runnable) {
        try {
            taskExecutor.submit(runnable).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void reportPlayer(String reporterUserId, String reportedUserId, EOS_EPlayerReportsCategory category, String message, String context) {
        this.callApi(() -> {
            EOS_Reports_SendPlayerBehaviorReportOptions reportOptions = new EOS_Reports_SendPlayerBehaviorReportOptions(reporterUserId, reportedUserId, category, message, context);
            this.platform.getReportsInterface().sendPlayerBehaviorReport(reportOptions, null, callbackInfo -> {
                if (callbackInfo.ResultCode.isSuccess()) {
                    log.info("Sent report from productUserId=[{}] to productUserId=[{}]", (Object)reporterUserId, (Object)reportedUserId);
                } else {
                    log.error("Failed to send report from productUserId=[{}] to productUserId=[{}] resultCode=[{}]", new Object[]{reporterUserId, reportedUserId, callbackInfo.ResultCode});
                }
            });
        });
    }

    protected void onLogMessage(@NotNull EOS_LogMessage logMessage) {
        switch (logMessage.Level) {
            case EOS_LOG_Fatal: 
            case EOS_LOG_Error: {
                log.error(logMessage.Message);
                break;
            }
            case EOS_LOG_Warning: {
                log.warn(logMessage.Message);
                break;
            }
            case EOS_LOG_Info: {
                log.info(logMessage.Message);
                break;
            }
            case EOS_LOG_Verbose: 
            case EOS_LOG_VeryVerbose: {
                log.debug(logMessage.Message);
            }
        }
    }
}

