/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.EOS_RTC_Audio_Interface;
import host.anzo.eossdk.eos.sdk.common.EOS_NotificationId;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.sdk.rtc.callbacks.EOS_RTC_OnBlockParticipantCallback;
import host.anzo.eossdk.eos.sdk.rtc.callbacks.EOS_RTC_OnDisconnectedCallback;
import host.anzo.eossdk.eos.sdk.rtc.callbacks.EOS_RTC_OnJoinRoomCallback;
import host.anzo.eossdk.eos.sdk.rtc.callbacks.EOS_RTC_OnLeaveRoomCallback;
import host.anzo.eossdk.eos.sdk.rtc.callbacks.EOS_RTC_OnParticipantStatusChangedCallback;
import host.anzo.eossdk.eos.sdk.rtc.callbacks.EOS_RTC_OnRoomStatisticsUpdatedCallback;
import host.anzo.eossdk.eos.sdk.rtc.options.EOS_RTC_AddNotifyDisconnectedOptions;
import host.anzo.eossdk.eos.sdk.rtc.options.EOS_RTC_AddNotifyParticipantStatusChangedOptions;
import host.anzo.eossdk.eos.sdk.rtc.options.EOS_RTC_AddNotifyRoomStatisticsUpdatedOptions;
import host.anzo.eossdk.eos.sdk.rtc.options.EOS_RTC_BlockParticipantOptions;
import host.anzo.eossdk.eos.sdk.rtc.options.EOS_RTC_JoinRoomOptions;
import host.anzo.eossdk.eos.sdk.rtc.options.EOS_RTC_LeaveRoomOptions;
import host.anzo.eossdk.eos.sdk.rtc.options.EOS_RTC_SetRoomSettingOptions;
import host.anzo.eossdk.eos.sdk.rtc.options.EOS_RTC_SetSettingOptions;
import host.anzo.eossdk.eos.utils.CallbackUtils;

public class EOS_RTC_Interface
extends PointerType {
    public EOS_RTC_Interface(Pointer address) {
        super(address);
    }

    public EOS_RTC_Interface() {
    }

    public EOS_RTC_Audio_Interface getAudioInterface() {
        return EOSLibrary.instance.EOS_RTC_GetAudioInterface(this);
    }

    public void joinRoom(EOS_RTC_JoinRoomOptions options, Pointer clientData, EOS_RTC_OnJoinRoomCallback completionDelegate) {
        EOSLibrary.instance.EOS_RTC_JoinRoom(this, options, clientData, completionDelegate);
    }

    public void leaveRoom(EOS_RTC_LeaveRoomOptions options, Pointer clientData, EOS_RTC_OnLeaveRoomCallback completionDelegate) {
        EOSLibrary.instance.EOS_RTC_LeaveRoom(this, options, clientData, completionDelegate);
    }

    public void blockParticipant(EOS_RTC_BlockParticipantOptions options, Pointer clientData, EOS_RTC_OnBlockParticipantCallback completionDelegate) {
        EOSLibrary.instance.EOS_RTC_BlockParticipant(this, options, clientData, completionDelegate);
    }

    public EOS_NotificationId addNotifyDisconnected(EOS_RTC_AddNotifyDisconnectedOptions options, Pointer clientData, EOS_RTC_OnDisconnectedCallback completionDelegate) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_RTC_AddNotifyDisconnected(this, options, clientData, completionDelegate);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, completionDelegate);
        }
        return notificationId;
    }

    public void removeNotifyDisconnected(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_RTC_RemoveNotifyDisconnected(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_NotificationId addNotifyParticipantStatusChanged(EOS_RTC_AddNotifyParticipantStatusChangedOptions options, Pointer clientData, EOS_RTC_OnParticipantStatusChangedCallback completionDelegate) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_RTC_AddNotifyParticipantStatusChanged(this, options, clientData, completionDelegate);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, completionDelegate);
        }
        return notificationId;
    }

    public void removeNotifyParticipantStatusChanged(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_RTC_RemoveNotifyParticipantStatusChanged(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_EResult setSetting(EOS_RTC_SetSettingOptions options) {
        return EOSLibrary.instance.EOS_RTC_SetSetting(this, options);
    }

    public EOS_EResult setRoomSetting(EOS_RTC_SetRoomSettingOptions options) {
        return EOSLibrary.instance.EOS_RTC_SetRoomSetting(this, options);
    }

    public EOS_NotificationId addNotifyRoomStatisticsUpdated(EOS_RTC_AddNotifyRoomStatisticsUpdatedOptions options, Pointer clientData, EOS_RTC_OnRoomStatisticsUpdatedCallback statisticsUpdateHandler) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_RTC_AddNotifyRoomStatisticsUpdated(this, options, clientData, statisticsUpdateHandler);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, statisticsUpdateHandler);
        }
        return notificationId;
    }

    public void removeNotifyRoomStatisticsUpdated(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_RTC_RemoveNotifyRoomStatisticsUpdated(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }
}

