/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.IntByReference;
import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.anticheat.common.EOS_AntiCheatCommon_ClientHandle;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_LogEventOptions;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_LogGameRoundEndOptions;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_LogGameRoundStartOptions;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_LogPlayerDespawnOptions;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_LogPlayerReviveOptions;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_LogPlayerSpawnOptions;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_LogPlayerTakeDamageOptions;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_LogPlayerTickOptions;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_LogPlayerUseAbilityOptions;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_LogPlayerUseWeaponOptions;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_RegisterEventOptions;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_SetClientDetailsOptions;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_SetGameSessionIdOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.callbacks.EOS_AntiCheatServer_OnClientActionRequiredCallback;
import host.anzo.eossdk.eos.sdk.anticheat.server.callbacks.EOS_AntiCheatServer_OnClientAuthStatusChangedCallback;
import host.anzo.eossdk.eos.sdk.anticheat.server.callbacks.EOS_AntiCheatServer_OnMessageToClientCallback;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_AddNotifyClientActionRequiredOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_AddNotifyClientAuthStatusChangedOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_AddNotifyMessageToClientOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_BeginSessionOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_EndSessionOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_GetProtectMessageOutputLengthOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_ProtectMessageOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_ReceiveMessageFromClientOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_RegisterClientOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_SetClientNetworkStateOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_UnprotectMessageOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_UnregisterClientOptions;
import host.anzo.eossdk.eos.sdk.common.EOS_NotificationId;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.utils.CallbackUtils;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class EOS_AntiCheatServer_Interface
extends PointerType {
    public EOS_AntiCheatServer_Interface(Pointer address) {
        super(address);
    }

    public EOS_AntiCheatServer_Interface() {
    }

    public EOS_NotificationId addNotifyMessageToClient(Pointer clientData, EOS_AntiCheatServer_OnMessageToClientCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_AntiCheatServer_AddNotifyMessageToClient(this, new EOS_AntiCheatServer_AddNotifyMessageToClientOptions(), clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifyMessageToClient(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_AntiCheatServer_RemoveNotifyMessageToClient(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_NotificationId addNotifyClientActionRequired(Pointer clientData, EOS_AntiCheatServer_OnClientActionRequiredCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_AntiCheatServer_AddNotifyClientActionRequired(this, new EOS_AntiCheatServer_AddNotifyClientActionRequiredOptions(), clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifyClientActionRequired(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_AntiCheatServer_RemoveNotifyClientActionRequired(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_NotificationId addNotifyClientAuthStatusChanged(Pointer clientData, EOS_AntiCheatServer_OnClientAuthStatusChangedCallback notificationFn) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_AntiCheatServer_AddNotifyClientAuthStatusChanged(this, new EOS_AntiCheatServer_AddNotifyClientAuthStatusChangedOptions(), clientData, notificationFn);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notificationFn);
        }
        return notificationId;
    }

    public void removeNotifyClientAuthStatusChanged(EOS_NotificationId notificationId) {
        EOSLibrary.instance.EOS_AntiCheatServer_RemoveNotifyClientAuthStatusChanged(this, notificationId);
        CallbackUtils.unregisterNotificationCallback(notificationId);
    }

    public EOS_EResult beginSession(EOS_AntiCheatServer_BeginSessionOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatServer_BeginSession(this, options);
    }

    public EOS_EResult endSession() {
        return EOSLibrary.instance.EOS_AntiCheatServer_EndSession(this, new EOS_AntiCheatServer_EndSessionOptions());
    }

    public EOS_EResult registerClient(EOS_AntiCheatServer_RegisterClientOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatServer_RegisterClient(this, options);
    }

    public EOS_EResult unregisterClient(@NotNull EOS_AntiCheatCommon_ClientHandle clientHandle) {
        return EOSLibrary.instance.EOS_AntiCheatServer_UnregisterClient(this, new EOS_AntiCheatServer_UnregisterClientOptions(clientHandle));
    }

    public EOS_EResult receiveMessageFromClient(@NotNull EOS_AntiCheatCommon_ClientHandle clientHandle, byte @NotNull [] data) {
        return EOSLibrary.instance.EOS_AntiCheatServer_ReceiveMessageFromClient(this, new EOS_AntiCheatServer_ReceiveMessageFromClientOptions(clientHandle, data));
    }

    public EOS_EResult setClientDetails(EOS_AntiCheatCommon_SetClientDetailsOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatServer_SetClientDetails(this, options);
    }

    public EOS_EResult setGameSessionId(String gameSessionId) {
        return EOSLibrary.instance.EOS_AntiCheatServer_SetGameSessionId(this, new EOS_AntiCheatCommon_SetGameSessionIdOptions(gameSessionId));
    }

    public EOS_EResult setClientNetworkState(EOS_AntiCheatCommon_ClientHandle clientHandle, boolean isNetworkActive) {
        return EOSLibrary.instance.EOS_AntiCheatServer_SetClientNetworkState(this, new EOS_AntiCheatServer_SetClientNetworkStateOptions(clientHandle, isNetworkActive));
    }

    public int getProtectMessageOutputLength(int dataSize) throws EOSException {
        IntByReference sizeBytesReference = new IntByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_AntiCheatServer_GetProtectMessageOutputLength(this, new EOS_AntiCheatServer_GetProtectMessageOutputLengthOptions(dataSize), sizeBytesReference);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return sizeBytesReference.getValue();
    }

    public ByteBuffer protectMessage(EOS_AntiCheatCommon_ClientHandle clientHandle, byte[] data, int outBufferSizeBytes) throws EOSException {
        IntByReference outBytesWritten;
        EOS_AntiCheatServer_ProtectMessageOptions.ByReference options = new EOS_AntiCheatServer_ProtectMessageOptions.ByReference(clientHandle, data, outBufferSizeBytes);
        ByteBuffer outBuffer = ByteBuffer.allocate(outBufferSizeBytes);
        EOS_EResult result = EOSLibrary.instance.EOS_AntiCheatServer_ProtectMessage(this, options, outBuffer, outBytesWritten = new IntByReference());
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return outBuffer;
    }

    public ByteBuffer unprotectMessage(EOS_AntiCheatCommon_ClientHandle clientHandle, byte[] data) throws EOSException {
        EOS_AntiCheatServer_UnprotectMessageOptions.ByReference options = new EOS_AntiCheatServer_UnprotectMessageOptions.ByReference(clientHandle, data);
        IntByReference outBytesWritten = new IntByReference();
        ByteBuffer outBuffer = ByteBuffer.allocate(data.length);
        EOS_EResult result = EOSLibrary.instance.EOS_AntiCheatServer_UnprotectMessage(this, options, outBuffer, outBytesWritten);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        outBuffer.limit(outBytesWritten.getValue());
        return outBuffer;
    }

    public EOS_EResult registerEvent(EOS_AntiCheatCommon_RegisterEventOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatServer_RegisterEvent(this, options);
    }

    public EOS_EResult logEvent(EOS_AntiCheatCommon_LogEventOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatServer_LogEvent(this, options);
    }

    public EOS_EResult logGameRoundStart(EOS_AntiCheatCommon_LogGameRoundStartOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatServer_LogGameRoundStart(this, options);
    }

    public EOS_EResult logGameRoundEnd(int winningTeamId) {
        return EOSLibrary.instance.EOS_AntiCheatServer_LogGameRoundEnd(this, new EOS_AntiCheatCommon_LogGameRoundEndOptions(winningTeamId));
    }

    public EOS_EResult logPlayerSpawn(EOS_AntiCheatCommon_LogPlayerSpawnOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatServer_LogPlayerSpawn(this, options);
    }

    public EOS_EResult logPlayerDespawn(EOS_AntiCheatCommon_LogPlayerDespawnOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatServer_LogPlayerDespawn(this, options);
    }

    public EOS_EResult logPlayerRevive(EOS_AntiCheatCommon_LogPlayerReviveOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatServer_LogPlayerRevive(this, options);
    }

    public EOS_EResult logPlayerTick(EOS_AntiCheatCommon_LogPlayerTickOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatServer_LogPlayerTick(this, options);
    }

    public EOS_EResult logPlayerUseWeapon(EOS_AntiCheatCommon_LogPlayerUseWeaponOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatServer_LogPlayerUseWeapon(this, options);
    }

    public EOS_EResult logPlayerUseAbility(EOS_AntiCheatCommon_LogPlayerUseAbilityOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatServer_LogPlayerUseAbility(this, options);
    }

    public EOS_EResult logPlayerTakeDamage(EOS_AntiCheatCommon_LogPlayerTakeDamageOptions options) {
        return EOSLibrary.instance.EOS_AntiCheatServer_LogPlayerTakeDamage(this, options);
    }
}

