/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.IntByReference;
import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.common.EOS_NotificationId;
import host.anzo.eossdk.eos.sdk.common.EOS_ProductUserId;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_ELoginStatus;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.sdk.connect.EOS_Connect_ExternalAccountInfo;
import host.anzo.eossdk.eos.sdk.connect.EOS_Connect_IdToken;
import host.anzo.eossdk.eos.sdk.connect.callbacks.EOS_Connect_OnAuthExpirationCallback;
import host.anzo.eossdk.eos.sdk.connect.callbacks.EOS_Connect_OnCreateDeviceIdCallback;
import host.anzo.eossdk.eos.sdk.connect.callbacks.EOS_Connect_OnCreateUserCallback;
import host.anzo.eossdk.eos.sdk.connect.callbacks.EOS_Connect_OnDeleteDeviceIdCallback;
import host.anzo.eossdk.eos.sdk.connect.callbacks.EOS_Connect_OnLinkAccountCallback;
import host.anzo.eossdk.eos.sdk.connect.callbacks.EOS_Connect_OnLoginCallback;
import host.anzo.eossdk.eos.sdk.connect.callbacks.EOS_Connect_OnLoginStatusChangedCallback;
import host.anzo.eossdk.eos.sdk.connect.callbacks.EOS_Connect_OnQueryExternalAccountMappingsCallback;
import host.anzo.eossdk.eos.sdk.connect.callbacks.EOS_Connect_OnQueryProductUserIdMappingsCallback;
import host.anzo.eossdk.eos.sdk.connect.callbacks.EOS_Connect_OnTransferDeviceIdAccountCallback;
import host.anzo.eossdk.eos.sdk.connect.callbacks.EOS_Connect_OnUnlinkAccountCallback;
import host.anzo.eossdk.eos.sdk.connect.callbacks.EOS_Connect_OnVerifyIdTokenCallback;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_AddNotifyAuthExpirationOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_AddNotifyLoginStatusChangedOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_CopyIdTokenOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_CopyProductUserExternalAccountByAccountIdOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_CopyProductUserExternalAccountByAccountTypeOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_CopyProductUserExternalAccountByIndexOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_CopyProductUserInfoOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_CreateDeviceIdOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_CreateUserOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_DeleteDeviceIdOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_GetExternalAccountMappingsOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_GetProductUserExternalAccountCountOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_GetProductUserIdMappingOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_LinkAccountOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_LoginOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_QueryExternalAccountMappingsOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_QueryProductUserIdMappingsOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_TransferDeviceIdAccountOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_UnlinkAccountOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_VerifyIdTokenOptions;
import host.anzo.eossdk.eos.utils.CallbackUtils;

public class EOS_Connect_Interface
extends PointerType {
    public static final int EOS_CONNECT_EXTERNAL_ACCOUNT_ID_MAX_LENGTH = 256;

    public EOS_Connect_Interface(Pointer address) {
        super(address);
    }

    public EOS_Connect_Interface() {
    }

    public void login(EOS_Connect_LoginOptions options, Pointer clientData, EOS_Connect_OnLoginCallback completionDelegate) {
        EOSLibrary.instance.EOS_Connect_Login(this, options, clientData, completionDelegate);
    }

    public void createUser(EOS_Connect_CreateUserOptions options, Pointer clientData, EOS_Connect_OnCreateUserCallback completionDelegate) {
        EOSLibrary.instance.EOS_Connect_CreateUser(this, options, clientData, completionDelegate);
    }

    public void linkAccount(EOS_Connect_LinkAccountOptions options, Pointer clientData, EOS_Connect_OnLinkAccountCallback completionDelegate) {
        EOSLibrary.instance.EOS_Connect_LinkAccount(this, options, clientData, completionDelegate);
    }

    public void unlinkAccount(EOS_Connect_UnlinkAccountOptions options, Pointer clientData, EOS_Connect_OnUnlinkAccountCallback completionDelegate) {
        EOSLibrary.instance.EOS_Connect_UnlinkAccount(this, options, clientData, completionDelegate);
    }

    public void createDeviceId(EOS_Connect_CreateDeviceIdOptions options, Pointer clientData, EOS_Connect_OnCreateDeviceIdCallback completionDelegate) {
        EOSLibrary.instance.EOS_Connect_CreateDeviceId(this, options, clientData, completionDelegate);
    }

    public void deleteDeviceId(EOS_Connect_DeleteDeviceIdOptions options, Pointer clientData, EOS_Connect_OnDeleteDeviceIdCallback completionDelegate) {
        EOSLibrary.instance.EOS_Connect_DeleteDeviceId(this, options, clientData, completionDelegate);
    }

    public void transferDeviceIdAccount(EOS_Connect_TransferDeviceIdAccountOptions options, Pointer clientData, EOS_Connect_OnTransferDeviceIdAccountCallback completionDelegate) {
        EOSLibrary.instance.EOS_Connect_TransferDeviceIdAccount(this, options, clientData, completionDelegate);
    }

    public void queryExternalAccountMappings(EOS_Connect_QueryExternalAccountMappingsOptions options, Pointer clientData, EOS_Connect_OnQueryExternalAccountMappingsCallback completionDelegate) {
        EOSLibrary.instance.EOS_Connect_QueryExternalAccountMappings(this, options, clientData, completionDelegate);
    }

    public void queryProductUserIdMappings(EOS_Connect_QueryProductUserIdMappingsOptions options, Pointer clientData, EOS_Connect_OnQueryProductUserIdMappingsCallback completionDelegate) {
        EOSLibrary.instance.EOS_Connect_QueryProductUserIdMappings(this, options, clientData, completionDelegate);
    }

    public EOS_ProductUserId getExternalAccountMapping(EOS_Connect_GetExternalAccountMappingsOptions options) {
        return EOSLibrary.instance.EOS_Connect_GetExternalAccountMapping(this, options);
    }

    public String getProductUserIdMapping(EOS_Connect_GetProductUserIdMappingOptions options) throws EOSException {
        byte[] outBuffer = new byte[256];
        IntByReference inOutBufferLength = new IntByReference(256);
        EOS_EResult result = EOSLibrary.instance.EOS_Connect_GetProductUserIdMapping(this, options, outBuffer, inOutBufferLength);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return new String(outBuffer, 0, inOutBufferLength.getValue());
    }

    public int getProductUserExternalAccountCount(EOS_Connect_GetProductUserExternalAccountCountOptions options) {
        return EOSLibrary.instance.EOS_Connect_GetProductUserExternalAccountCount(this, options);
    }

    public EOS_Connect_ExternalAccountInfo copyProductUserExternalAccountByIndex(EOS_Connect_CopyProductUserExternalAccountByIndexOptions options) throws EOSException {
        EOS_Connect_ExternalAccountInfo.ByReference outExternalAccountInfo = new EOS_Connect_ExternalAccountInfo.ByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_Connect_CopyProductUserExternalAccountByIndex(this, options, outExternalAccountInfo);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return outExternalAccountInfo;
    }

    public EOS_Connect_ExternalAccountInfo copyProductUserExternalAccountByAccountType(EOS_Connect_CopyProductUserExternalAccountByAccountTypeOptions options) throws EOSException {
        EOS_Connect_ExternalAccountInfo.ByReference outExternalAccountInfo = new EOS_Connect_ExternalAccountInfo.ByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_Connect_CopyProductUserExternalAccountByAccountType(this, options, outExternalAccountInfo);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return outExternalAccountInfo;
    }

    public EOS_Connect_ExternalAccountInfo copyProductUserExternalAccountByAccountId(EOS_Connect_CopyProductUserExternalAccountByAccountIdOptions options) throws EOSException {
        EOS_Connect_ExternalAccountInfo.ByReference outExternalAccountInfo = new EOS_Connect_ExternalAccountInfo.ByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_Connect_CopyProductUserExternalAccountByAccountId(this, options, outExternalAccountInfo);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return outExternalAccountInfo;
    }

    public EOS_Connect_ExternalAccountInfo copyProductUserInfo(EOS_Connect_CopyProductUserInfoOptions options) throws EOSException {
        EOS_Connect_ExternalAccountInfo.ByReference outExternalAccountInfo = new EOS_Connect_ExternalAccountInfo.ByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_Connect_CopyProductUserInfo(this, options, outExternalAccountInfo);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return outExternalAccountInfo;
    }

    public int getLoggedInUsersCount() {
        return EOSLibrary.instance.EOS_Connect_GetLoggedInUsersCount(this);
    }

    public EOS_ProductUserId getLoggedInUserByIndex(int index) {
        return EOSLibrary.instance.EOS_Connect_GetLoggedInUserByIndex(this, index);
    }

    public EOS_ELoginStatus getLoginStatus(EOS_ProductUserId localUserId) {
        return EOSLibrary.instance.EOS_Connect_GetLoginStatus(this, localUserId);
    }

    public EOS_NotificationId addNotifyAuthExpiration(EOS_Connect_AddNotifyAuthExpirationOptions options, Pointer clientData, EOS_Connect_OnAuthExpirationCallback notification) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_Connect_AddNotifyAuthExpiration(this, options, clientData, notification);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notification);
        }
        return notificationId;
    }

    public void removeNotifyAuthExpiration(EOS_NotificationId inId) {
        EOSLibrary.instance.EOS_Connect_RemoveNotifyAuthExpiration(this, inId);
        CallbackUtils.unregisterNotificationCallback(inId);
    }

    public EOS_NotificationId addNotifyLoginStatusChanged(EOS_Connect_AddNotifyLoginStatusChangedOptions options, Pointer clientData, EOS_Connect_OnLoginStatusChangedCallback notification) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_Connect_AddNotifyLoginStatusChanged(this, options, clientData, notification);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notification);
        }
        return notificationId;
    }

    public void removeNotifyLoginStatusChanged(EOS_NotificationId inId) {
        EOSLibrary.instance.EOS_Connect_RemoveNotifyLoginStatusChanged(this, inId);
        CallbackUtils.unregisterNotificationCallback(inId);
    }

    public EOS_Connect_IdToken copyIdToken(EOS_Connect_CopyIdTokenOptions options) throws EOSException {
        EOS_Connect_IdToken.ByReference outIdToken = new EOS_Connect_IdToken.ByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_Connect_CopyIdToken(this, options, outIdToken);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return outIdToken;
    }

    public void verifyIdToken(EOS_Connect_VerifyIdTokenOptions options, Pointer clientData, EOS_Connect_OnVerifyIdTokenCallback completionDelegate) {
        EOSLibrary.instance.EOS_Connect_VerifyIdToken(this, options, clientData, completionDelegate);
    }
}

