/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk.common;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.IntByReference;
import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.common.EOS_Bool;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import java.nio.ByteBuffer;

public class EOS_ProductUserId
extends PointerType {
    public static int EOS_PRODUCTUSERID_MAX_LENGTH = 32;

    public EOS_ProductUserId(Pointer address) {
        super(address);
    }

    public EOS_ProductUserId() {
    }

    public static EOS_ProductUserId fromString(String productUserIdString) {
        return EOSLibrary.instance.EOS_ProductUserId_FromString(productUserIdString);
    }

    public boolean isValid() {
        return EOSLibrary.instance.EOS_ProductUserId_IsValid(this) == EOS_Bool.EOS_TRUE;
    }

    public String getString() throws EOSException {
        IntByReference inOutBufferLength;
        ByteBuffer outBuffer = ByteBuffer.allocate(EOS_PRODUCTUSERID_MAX_LENGTH + 1);
        EOS_EResult result = EOSLibrary.instance.EOS_ProductUserId_ToString(this, outBuffer, inOutBufferLength = new IntByReference(outBuffer.capacity()));
        if (result.isSuccess()) {
            return new String(outBuffer.array(), 0, inOutBufferLength.getValue()).trim();
        }
        throw EOSException.fromResult(result);
    }
}

