/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eosex;

import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOS_AntiCheatClient_Interface;
import host.anzo.eossdk.eos.sdk.anticheat.client.callbackresults.EOS_AntiCheatClient_OnClientIntegrityViolatedCallbackInfo;
import host.anzo.eossdk.eos.sdk.anticheat.client.callbackresults.EOS_AntiCheatClient_OnMessageToServerCallbackInfo;
import host.anzo.eossdk.eos.sdk.auth.EOS_Auth_IdToken;
import host.anzo.eossdk.eos.sdk.auth.options.EOS_Auth_LoginOptions;
import host.anzo.eossdk.eos.sdk.common.EOS_NotificationId;
import host.anzo.eossdk.eos.sdk.common.EOS_ProductUserId;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.sdk.connect.callbackresults.EOS_Connect_AuthExpirationCallbackInfo;
import host.anzo.eossdk.eos.sdk.connect.callbackresults.EOS_Connect_CreateUserCallbackInfo;
import host.anzo.eossdk.eos.sdk.connect.callbackresults.EOS_Connect_LoginCallbackInfo;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_AddNotifyAuthExpirationOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_CreateUserOptions;
import host.anzo.eossdk.eos.sdk.connect.options.EOS_Connect_LoginOptions;
import host.anzo.eossdk.eosex.AEOSBase;
import host.anzo.eossdk.eosex.EOSClientOptions;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AEOSClient
extends AEOSBase<EOSClientOptions> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AEOSClient.class);
    private EOS_AntiCheatClient_Interface antiCheatClient;
    private EOS_NotificationId authExpirationNotificationId;
    private EOS_NotificationId messageToServerNotificationId;
    private EOS_NotificationId clientIntegrityViolatedNotificationId;
    private EOS_ProductUserId productUserId;
    protected EOS_Auth_IdToken authIdToken;

    public AEOSClient start(EOSClientOptions options) throws EOSException {
        super.start(options);
        this.doAuthenticate();
        return this;
    }

    private void doAuthenticate() {
        if (((EOSClientOptions)this.options).isUseEpicAuthentication()) {
            this.platform.getAuthInterface().login(this.getAuthLoginOptions(), null, loginCallbackInfo -> {
                try (EOS_Auth_IdToken authIdToken = this.platform.getAuthInterface().copyIdToken(loginCallbackInfo.SelectedAccountId);){
                    this.platform.getConnectInterface().login(this.getConnectLoginOptions(authIdToken), null, this::onConnectLogin);
                }
                catch (Exception e) {
                    log.error("Failed to copyIdToken", (Throwable)e);
                }
            });
        } else {
            this.platform.getConnectInterface().login(this.getConnectLoginOptions(null), null, this::onConnectLogin);
        }
    }

    protected abstract EOS_Auth_LoginOptions getAuthLoginOptions();

    protected abstract EOS_Connect_LoginOptions getConnectLoginOptions(EOS_Auth_IdToken var1);

    private void onConnectLogin(@NotNull EOS_Connect_LoginCallbackInfo data) throws EOSException {
        if (data.ResultCode.isSuccess()) {
            log.info("EOS_Connect_Login completed with ProductUserId: {}", (Object)data.LocalUserId.getString());
            this.onConnectLoginComplete(data.ResultCode, data.LocalUserId);
        } else if (data.ResultCode == EOS_EResult.EOS_InvalidUser) {
            log.warn("EOS_Connect_Login failed with result={}. Trying to create new user...", (Object)data.ResultCode);
            EOS_Connect_CreateUserOptions createUserOptions = new EOS_Connect_CreateUserOptions();
            if (data.ContinuanceToken != null) {
                createUserOptions.ContinuanceToken = data.ContinuanceToken;
            }
            this.platform.getConnectInterface().createUser(createUserOptions, data.ClientData, this::onCreateUser);
        } else {
            this.onConnectLoginFailed(data.ResultCode);
        }
    }

    private void onCreateUser(@NotNull EOS_Connect_CreateUserCallbackInfo data) throws EOSException {
        if (data.ResultCode.isSuccess()) {
            log.info("EOS_Connect_CreateUser completed with ProductUserId: {}, Result: {}", (Object)data.LocalUserId.getString(), (Object)data.ResultCode);
            this.onConnectLoginComplete(data.ResultCode, data.LocalUserId);
        } else {
            this.onConnectLoginFailed(data.ResultCode);
        }
    }

    protected void onConnectLoginFailed(EOS_EResult result) {
        log.error("Connect to services failed with error: {}", (Object)result);
    }

    protected void onConnectLoginComplete(EOS_EResult result, EOS_ProductUserId productUserId) {
        this.productUserId = productUserId;
        this.authExpirationNotificationId = this.platform.getConnectInterface().addNotifyAuthExpiration(new EOS_Connect_AddNotifyAuthExpirationOptions(), null, this::onAuthExpiration);
        if (((EOSClientOptions)this.options).isAntiCheatEnabled()) {
            this.antiCheatClient = this.platform.getAntiCheatClientInterface();
            if (this.antiCheatClient == null) {
                throw new RuntimeException("Failed to getAntiCheatClientInterface");
            }
            switch (((EOSClientOptions)this.options).getAntiCheatMode()) {
                case EOS_ACCM_ClientServer: {
                    this.messageToServerNotificationId = this.antiCheatClient.addNotifyMessageToServer(null, this::onMessageToServer);
                    if (!this.messageToServerNotificationId.isValid()) {
                        throw new RuntimeException("Failed to addNotifyMessageToServer");
                    }
                    this.clientIntegrityViolatedNotificationId = this.antiCheatClient.addNotifyClientIntegrityViolated(null, this::onClientIntegrityViolated);
                    if (this.clientIntegrityViolatedNotificationId.isValid()) break;
                    throw new RuntimeException("Failed to addNotifyClientIntegrityViolated");
                }
                case EOS_ACCM_PeerToPeer: {
                    throw new UnsupportedOperationException("Peer2Peer mode isn't implemented");
                }
            }
            EOS_EResult beginSessionResult = this.antiCheatClient.beginSession(productUserId, ((EOSClientOptions)this.options).getAntiCheatMode());
            if (!beginSessionResult.isSuccess()) {
                throw new RuntimeException("Failed to anti-cheat beginSession: " + (Object)((Object)beginSessionResult));
            }
        }
    }

    private void onAuthExpiration(@NotNull EOS_Connect_AuthExpirationCallbackInfo authExpirationCallbackInfo) {
        this.doAuthenticate();
    }

    @Override
    public void shutdown() {
        if (this.authExpirationNotificationId != null) {
            this.platform.getConnectInterface().removeNotifyAuthExpiration(this.authExpirationNotificationId);
        }
        if (this.antiCheatClient != null) {
            switch (((EOSClientOptions)this.options).getAntiCheatMode()) {
                case EOS_ACCM_ClientServer: {
                    if (this.messageToServerNotificationId.isValid()) {
                        this.antiCheatClient.removeNotifyMessageToServer(this.messageToServerNotificationId);
                    }
                    if (!this.clientIntegrityViolatedNotificationId.isValid()) break;
                    this.antiCheatClient.removeNotifyClientIntegrityViolated(this.clientIntegrityViolatedNotificationId);
                    break;
                }
                case EOS_ACCM_PeerToPeer: {
                    throw new UnsupportedOperationException("Peer2Peer mode isn't implemented");
                }
            }
            EOS_EResult endSessionResult = this.antiCheatClient.endSession();
            if (!endSessionResult.isSuccess()) {
                throw new RuntimeException("Failed to anti-cheat endSession: " + (Object)((Object)endSessionResult));
            }
        }
        super.shutdown();
    }

    protected void onMessageToServer(@NotNull EOS_AntiCheatClient_OnMessageToServerCallbackInfo callbackInfo) {
    }

    protected void onClientIntegrityViolated(EOS_AntiCheatClient_OnClientIntegrityViolatedCallbackInfo callbackInfo) {
    }

    @Generated
    public EOS_AntiCheatClient_Interface getAntiCheatClient() {
        return this.antiCheatClient;
    }

    @Generated
    public EOS_NotificationId getAuthExpirationNotificationId() {
        return this.authExpirationNotificationId;
    }

    @Generated
    public EOS_NotificationId getMessageToServerNotificationId() {
        return this.messageToServerNotificationId;
    }

    @Generated
    public EOS_NotificationId getClientIntegrityViolatedNotificationId() {
        return this.clientIntegrityViolatedNotificationId;
    }

    @Generated
    public EOS_ProductUserId getProductUserId() {
        return this.productUserId;
    }

    @Generated
    public EOS_Auth_IdToken getAuthIdToken() {
        return this.authIdToken;
    }
}

