package host.anzo.eossdk.eos.sdk.lobby.options;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;

import static com.sun.jna.Structure.FieldOrder;

/**
 * @author Anton Lasevich
 * @since 8/18/2023
 */
@FieldOrder({"ApiVersion"})
public class EOS_Lobby_AddNotifyLobbyUpdateReceivedOptions extends Structure {
	/** The most recent version of the EOS_Lobby_AddNotifyLobbyUpdateReceived API. */
	public static final int EOS_LOBBY_ADDNOTIFYLOBBYUPDATERECEIVED_API_LATEST = 1;

	/** API Version: Set this to {@link #EOS_LOBBY_ADDNOTIFYLOBBYUPDATERECEIVED_API_LATEST}. */
	public int ApiVersion;

	public EOS_Lobby_AddNotifyLobbyUpdateReceivedOptions() {
		super();
		ApiVersion = EOS_LOBBY_ADDNOTIFYLOBBYUPDATERECEIVED_API_LATEST;
	}

	public EOS_Lobby_AddNotifyLobbyUpdateReceivedOptions(Pointer peer) {
		super(peer);
	}

	public static class ByReference extends EOS_Lobby_AddNotifyLobbyUpdateReceivedOptions implements Structure.ByReference {
	}

	public static class ByValue extends EOS_Lobby_AddNotifyLobbyUpdateReceivedOptions implements Structure.ByValue {
	}
}