/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.PointerByReference;
import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.sdk.titlestorage.EOS_TitleStorageFileTransferRequest;
import host.anzo.eossdk.eos.sdk.titlestorage.EOS_TitleStorage_FileMetadata;
import host.anzo.eossdk.eos.sdk.titlestorage.callbacks.EOS_TitleStorage_OnDeleteCacheCompleteCallback;
import host.anzo.eossdk.eos.sdk.titlestorage.callbacks.EOS_TitleStorage_OnQueryFileCompleteCallback;
import host.anzo.eossdk.eos.sdk.titlestorage.callbacks.EOS_TitleStorage_OnQueryFileListCompleteCallback;
import host.anzo.eossdk.eos.sdk.titlestorage.callbacks.EOS_TitleStorage_OnReadFileCompleteCallback;
import host.anzo.eossdk.eos.sdk.titlestorage.options.EOS_TitleStorage_CopyFileMetadataAtIndexOptions;
import host.anzo.eossdk.eos.sdk.titlestorage.options.EOS_TitleStorage_CopyFileMetadataByFilenameOptions;
import host.anzo.eossdk.eos.sdk.titlestorage.options.EOS_TitleStorage_DeleteCacheOptions;
import host.anzo.eossdk.eos.sdk.titlestorage.options.EOS_TitleStorage_GetFileMetadataCountOptions;
import host.anzo.eossdk.eos.sdk.titlestorage.options.EOS_TitleStorage_QueryFileListOptions;
import host.anzo.eossdk.eos.sdk.titlestorage.options.EOS_TitleStorage_QueryFileOptions;
import host.anzo.eossdk.eos.sdk.titlestorage.options.EOS_TitleStorage_ReadFileOptions;

public class EOS_TitleStorage_Interface
extends PointerType {
    public EOS_TitleStorage_Interface(Pointer address) {
        super(address);
    }

    public EOS_TitleStorage_Interface() {
    }

    public void queryFile(EOS_TitleStorage_QueryFileOptions options, Pointer clientData, EOS_TitleStorage_OnQueryFileCompleteCallback completionCallback) {
        EOSLibrary.instance.EOS_TitleStorage_QueryFile(this, options, clientData, completionCallback);
    }

    public void queryFileList(EOS_TitleStorage_QueryFileListOptions options, Pointer clientData, EOS_TitleStorage_OnQueryFileListCompleteCallback completionCallback) {
        EOSLibrary.instance.EOS_TitleStorage_QueryFileList(this, options, clientData, completionCallback);
    }

    public EOS_TitleStorage_FileMetadata copyFileMetadataByFilename(EOS_TitleStorage_CopyFileMetadataByFilenameOptions options) throws EOSException {
        PointerByReference outMetadata = new PointerByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_TitleStorage_CopyFileMetadataByFilename(this, options, outMetadata);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        EOS_TitleStorage_FileMetadata metadata = new EOS_TitleStorage_FileMetadata(outMetadata.getValue());
        metadata.read();
        return metadata;
    }

    public int getFileMetadataCount(EOS_TitleStorage_GetFileMetadataCountOptions options) {
        return EOSLibrary.instance.EOS_TitleStorage_GetFileMetadataCount(this, options);
    }

    public EOS_TitleStorage_FileMetadata copyFileMetadataAtIndex(EOS_TitleStorage_CopyFileMetadataAtIndexOptions options) throws EOSException {
        PointerByReference outMetadata = new PointerByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_TitleStorage_CopyFileMetadataAtIndex(this, options, outMetadata);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        EOS_TitleStorage_FileMetadata metadata = new EOS_TitleStorage_FileMetadata(outMetadata.getValue());
        metadata.read();
        return metadata;
    }

    public EOS_TitleStorageFileTransferRequest readFile(EOS_TitleStorage_ReadFileOptions options, Pointer clientData, EOS_TitleStorage_OnReadFileCompleteCallback completionCallback) {
        return EOSLibrary.instance.EOS_TitleStorage_ReadFile(this, options, clientData, completionCallback);
    }

    public EOS_EResult deleteCache(EOS_TitleStorage_DeleteCacheOptions options, Pointer clientData, EOS_TitleStorage_OnDeleteCacheCompleteCallback completionCallback) {
        return EOSLibrary.instance.EOS_TitleStorage_DeleteCache(this, options, clientData, completionCallback);
    }
}

