/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eosex;

import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOS_AntiCheatServer_Interface;
import host.anzo.eossdk.eos.sdk.anticheat.common.EOS_AntiCheatCommon_ClientHandle;
import host.anzo.eossdk.eos.sdk.anticheat.common.callbackresults.EOS_AntiCheatCommon_OnClientActionRequiredCallbackInfo;
import host.anzo.eossdk.eos.sdk.anticheat.common.callbackresults.EOS_AntiCheatCommon_OnClientAuthStatusChangedCallbackInfo;
import host.anzo.eossdk.eos.sdk.anticheat.common.callbackresults.EOS_AntiCheatCommon_OnMessageToClientCallbackInfo;
import host.anzo.eossdk.eos.sdk.anticheat.common.enums.EOS_EAntiCheatCommonClientAction;
import host.anzo.eossdk.eos.sdk.anticheat.common.options.EOS_AntiCheatCommon_SetClientDetailsOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_BeginSessionOptions;
import host.anzo.eossdk.eos.sdk.anticheat.server.options.EOS_AntiCheatServer_RegisterClientOptions;
import host.anzo.eossdk.eos.sdk.common.EOS_NotificationId;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eosex.AEOSBase;
import host.anzo.eossdk.eosex.AEOSNetworkClient;
import host.anzo.eossdk.eosex.EOSServerOptions;
import java.nio.ByteBuffer;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AEOSServer
extends AEOSBase<EOSServerOptions> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AEOSServer.class);
    private EOS_AntiCheatServer_Interface antiCheatServer;
    private EOS_NotificationId messageToClientNotificationId;
    private EOS_NotificationId clientActionRequiredNotificationId;
    private EOS_NotificationId clientAuthStatusChangedNotificationId;

    public AEOSServer start(EOSServerOptions options) throws EOSException {
        super.start(options);
        if (options.isAntiCheatEnabled()) {
            this.antiCheatServer = this.platform.getAntiCheatServerInterface();
            if (this.antiCheatServer == null) {
                throw new RuntimeException("Failed to getAntiCheatServerInterface");
            }
            this.messageToClientNotificationId = this.antiCheatServer.addNotifyMessageToClient(null, this::onMessageToClient);
            if (!this.messageToClientNotificationId.isValid()) {
                throw new RuntimeException("Failed to addNotifyMessageToClient");
            }
            this.clientActionRequiredNotificationId = this.antiCheatServer.addNotifyClientActionRequired(null, this::onClientActionRequired);
            if (!this.clientActionRequiredNotificationId.isValid()) {
                throw new RuntimeException("Failed to addNotifyClientActionRequired");
            }
            this.clientAuthStatusChangedNotificationId = this.antiCheatServer.addNotifyClientAuthStatusChanged(null, this::onClientAuthStatusChanged);
            if (!this.clientAuthStatusChangedNotificationId.isValid()) {
                throw new RuntimeException("Failed to addNotifyClientAuthStatusChanged");
            }
            EOS_EResult beginSessionResult = this.antiCheatServer.beginSession(new EOS_AntiCheatServer_BeginSessionOptions(options));
            if (!beginSessionResult.isSuccess()) {
                throw new RuntimeException("Failed to anti-cheat beginSession: " + (Object)((Object)beginSessionResult));
            }
        }
        return this;
    }

    @Override
    public void shutdown() {
        if (this.antiCheatServer != null) {
            if (this.messageToClientNotificationId.isValid()) {
                this.antiCheatServer.removeNotifyMessageToClient(this.messageToClientNotificationId);
            }
            if (this.clientActionRequiredNotificationId.isValid()) {
                this.antiCheatServer.removeNotifyClientActionRequired(this.clientActionRequiredNotificationId);
            }
            if (this.clientAuthStatusChangedNotificationId.isValid()) {
                this.antiCheatServer.removeNotifyClientAuthStatusChanged(this.clientAuthStatusChangedNotificationId);
            }
        }
        super.shutdown();
    }

    public EOS_EResult onNetworkClientConnected(@NotNull AEOSNetworkClient antiCheatClient) {
        return this.registerClient(antiCheatClient);
    }

    private EOS_EResult registerClient(@NotNull AEOSNetworkClient antiCheatClient) {
        EOS_EResult result = this.antiCheatServer.registerClient(new EOS_AntiCheatServer_RegisterClientOptions(antiCheatClient));
        if (!result.isSuccess()) {
            log.error("RegisterClient failed for client=[{}] with error=[{}]", (Object)antiCheatClient, (Object)result);
            return result;
        }
        result = this.antiCheatServer.setClientDetails(new EOS_AntiCheatCommon_SetClientDetailsOptions(antiCheatClient));
        if (!result.isSuccess()) {
            log.error("SetClientDetails failed for client=[{}] with error=[{}]", (Object)antiCheatClient, (Object)result);
            return result;
        }
        return EOS_EResult.EOS_Success;
    }

    public EOS_EResult onNetworkClientDisconnected(@NotNull AEOSNetworkClient networkClient) {
        EOS_EResult result = this.antiCheatServer.unregisterClient(networkClient);
        if (!result.isSuccess()) {
            log.error("RegisterClient failed for client=[{}] with error=[{}]", (Object)networkClient, (Object)result);
            return result;
        }
        return EOS_EResult.EOS_Success;
    }

    public abstract AEOSNetworkClient getNetworkClient(long var1);

    private AEOSNetworkClient getNetworkClient(@NotNull EOS_AntiCheatCommon_ClientHandle handle) {
        return this.getNetworkClient(handle.getValue());
    }

    protected void onMessageToClient(@NotNull EOS_AntiCheatCommon_OnMessageToClientCallbackInfo callbackInfo) throws EOSException {
        AEOSNetworkClient antiCheatClient = this.getNetworkClient(callbackInfo.ClientHandle);
        if (antiCheatClient != null) {
            ByteBuffer data = callbackInfo.getByteBuffer();
            if (((EOSServerOptions)this.options).isEnableNetworkProtection()) {
                int protectMessageLength = this.antiCheatServer.getProtectMessageOutputLength(data.capacity());
                if (protectMessageLength > 0) {
                    ByteBuffer encryptedData = this.antiCheatServer.protectMessage(callbackInfo.ClientHandle, data.array(), protectMessageLength);
                    antiCheatClient.sendEacData(encryptedData);
                }
            } else {
                antiCheatClient.sendEacData(data);
            }
        }
    }

    protected void onClientActionRequired(@NotNull EOS_AntiCheatCommon_OnClientActionRequiredCallbackInfo callbackInfo) {
        AEOSNetworkClient networkClient = this.getNetworkClient(callbackInfo.ClientHandle);
        if (networkClient != null && callbackInfo.ClientAction == EOS_EAntiCheatCommonClientAction.EOS_ACCCA_RemovePlayer) {
            networkClient.close(callbackInfo.ActionReasonCode, callbackInfo.ActionReasonDetailsString);
        }
    }

    protected void onClientAuthStatusChanged(EOS_AntiCheatCommon_OnClientAuthStatusChangedCallbackInfo callbackInfo) {
    }
}

