/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.PointerByReference;
import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.auth.EOS_Auth_IdToken;
import host.anzo.eossdk.eos.sdk.auth.EOS_Auth_Token;
import host.anzo.eossdk.eos.sdk.auth.callbacks.EOS_Auth_OnDeletePersistentAuthCallback;
import host.anzo.eossdk.eos.sdk.auth.callbacks.EOS_Auth_OnLinkAccountCallback;
import host.anzo.eossdk.eos.sdk.auth.callbacks.EOS_Auth_OnLoginCallback;
import host.anzo.eossdk.eos.sdk.auth.callbacks.EOS_Auth_OnLoginStatusChangedCallback;
import host.anzo.eossdk.eos.sdk.auth.callbacks.EOS_Auth_OnLogoutCallback;
import host.anzo.eossdk.eos.sdk.auth.callbacks.EOS_Auth_OnQueryIdTokenCallback;
import host.anzo.eossdk.eos.sdk.auth.callbacks.EOS_Auth_OnVerifyIdTokenCallback;
import host.anzo.eossdk.eos.sdk.auth.callbacks.EOS_Auth_OnVerifyUserAuthCallback;
import host.anzo.eossdk.eos.sdk.auth.options.EOS_Auth_AddNotifyLoginStatusChangedOptions;
import host.anzo.eossdk.eos.sdk.auth.options.EOS_Auth_CopyIdTokenOptions;
import host.anzo.eossdk.eos.sdk.auth.options.EOS_Auth_CopyUserAuthTokenOptions;
import host.anzo.eossdk.eos.sdk.auth.options.EOS_Auth_DeletePersistentAuthOptions;
import host.anzo.eossdk.eos.sdk.auth.options.EOS_Auth_LinkAccountOptions;
import host.anzo.eossdk.eos.sdk.auth.options.EOS_Auth_LoginOptions;
import host.anzo.eossdk.eos.sdk.auth.options.EOS_Auth_LogoutOptions;
import host.anzo.eossdk.eos.sdk.auth.options.EOS_Auth_QueryIdTokenOptions;
import host.anzo.eossdk.eos.sdk.auth.options.EOS_Auth_VerifyIdTokenOptions;
import host.anzo.eossdk.eos.sdk.auth.options.EOS_Auth_VerifyUserAuthOptions;
import host.anzo.eossdk.eos.sdk.common.EOS_EpicAccountId;
import host.anzo.eossdk.eos.sdk.common.EOS_NotificationId;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_ELoginStatus;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.utils.CallbackUtils;

public class EOS_Auth_Interface
extends PointerType {
    public EOS_Auth_Interface(Pointer address) {
        super(address);
    }

    public EOS_Auth_Interface() {
    }

    public void login(EOS_Auth_LoginOptions options, Pointer clientData, EOS_Auth_OnLoginCallback completionDelegate) {
        EOSLibrary.instance.EOS_Auth_Login(this, options, clientData, completionDelegate);
    }

    public void logout(EOS_Auth_LogoutOptions options, Pointer clientData, EOS_Auth_OnLogoutCallback completionDelegate) {
        EOSLibrary.instance.EOS_Auth_Logout(this, options, clientData, completionDelegate);
    }

    public void linkAccount(EOS_Auth_LinkAccountOptions options, Pointer clientData, EOS_Auth_OnLinkAccountCallback completionDelegate) {
        EOSLibrary.instance.EOS_Auth_LinkAccount(this, options, clientData, completionDelegate);
    }

    public void deletePersistentAuth(EOS_Auth_DeletePersistentAuthOptions options, Pointer clientData, EOS_Auth_OnDeletePersistentAuthCallback completionDelegate) {
        EOSLibrary.instance.EOS_Auth_DeletePersistentAuth(this, options, clientData, completionDelegate);
    }

    public void verifyUserAuth(EOS_Auth_VerifyUserAuthOptions options, Pointer clientData, EOS_Auth_OnVerifyUserAuthCallback completionDelegate) {
        EOSLibrary.instance.EOS_Auth_VerifyUserAuth(this, options, clientData, completionDelegate);
    }

    public int getLoggedInAccountsCount() {
        return EOSLibrary.instance.EOS_Auth_GetLoggedInAccountsCount(this);
    }

    public EOS_EpicAccountId getLoggedInAccountByIndex(int index) {
        return EOSLibrary.instance.EOS_Auth_GetLoggedInAccountByIndex(this, index);
    }

    public EOS_ELoginStatus getLoginStatus(EOS_EpicAccountId localUserId) {
        return EOSLibrary.instance.EOS_Auth_GetLoginStatus(this, localUserId);
    }

    public EOS_Auth_Token copyUserAuthToken(EOS_Auth_CopyUserAuthTokenOptions options, EOS_EpicAccountId localUserId) throws EOSException {
        PointerByReference authTokenReference = new PointerByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_Auth_CopyUserAuthToken(this, options, localUserId, authTokenReference);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        EOS_Auth_Token authToken = new EOS_Auth_Token(authTokenReference.getValue());
        authToken.read();
        return authToken;
    }

    public EOS_Auth_IdToken copyIdToken(EOS_EpicAccountId accountId) throws EOSException {
        PointerByReference authIdTokenReference = new PointerByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_Auth_CopyIdToken(this, new EOS_Auth_CopyIdTokenOptions(accountId), authIdTokenReference);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        EOS_Auth_IdToken idToken = new EOS_Auth_IdToken(authIdTokenReference.getValue());
        idToken.read();
        return idToken;
    }

    public void queryIdToken(EOS_Auth_QueryIdTokenOptions options, Pointer clientData, EOS_Auth_OnQueryIdTokenCallback completionDelegate) {
        EOSLibrary.instance.EOS_Auth_QueryIdToken(this, options, clientData, completionDelegate);
    }

    public void verifyIdToken(EOS_Auth_VerifyIdTokenOptions options, Pointer clientData, EOS_Auth_OnVerifyIdTokenCallback completionDelegate) {
        EOSLibrary.instance.EOS_Auth_VerifyIdToken(this, options, clientData, completionDelegate);
    }

    public EOS_EpicAccountId getSelectedAccountId(EOS_EpicAccountId localUserId) throws EOSException {
        EOS_EpicAccountId epicAccountId = new EOS_EpicAccountId();
        EOS_EResult result = EOSLibrary.instance.EOS_Auth_GetSelectedAccountId(this, localUserId, epicAccountId);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return epicAccountId;
    }

    public int getMergedAccountsCount(EOS_EpicAccountId localUserId) {
        return EOSLibrary.instance.EOS_Auth_GetMergedAccountsCount(this, localUserId);
    }

    public EOS_EpicAccountId getMergedAccountByIndex(EOS_EpicAccountId localUserId, int index) {
        return EOSLibrary.instance.EOS_Auth_GetMergedAccountByIndex(this, localUserId, index);
    }

    public EOS_NotificationId addNotifyLoginStatusChanged(EOS_Auth_AddNotifyLoginStatusChangedOptions options, Pointer clientData, EOS_Auth_OnLoginStatusChangedCallback notification) {
        EOS_NotificationId notificationId = EOSLibrary.instance.EOS_Auth_AddNotifyLoginStatusChanged(this, options, clientData, notification);
        if (notificationId.isValid()) {
            CallbackUtils.registerNotificationCallback(notificationId, notification);
        }
        return notificationId;
    }

    public void removeNotifyLoginStatusChanged(EOS_NotificationId inId) {
        EOSLibrary.instance.EOS_Auth_RemoveNotifyLoginStatusChanged(this, inId);
        CallbackUtils.unregisterNotificationCallback(inId);
    }
}

