/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk.sessions.callbackresults;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import host.anzo.eossdk.eos.sdk.common.EOS_ProductUserId;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Structure.FieldOrder(value={"ResultCode", "ClientData", "RegisteredPlayers", "RegisteredPlayersCount", "SanctionedPlayers", "SanctionedPlayersCount"})
public class EOS_Sessions_RegisterPlayersCallbackInfo
extends Structure {
    public EOS_EResult ResultCode;
    public Pointer ClientData;
    public Pointer RegisteredPlayers;
    public int RegisteredPlayersCount;
    public Pointer SanctionedPlayers;
    public int SanctionedPlayersCount;

    public EOS_Sessions_RegisterPlayersCallbackInfo() {
    }

    public EOS_Sessions_RegisterPlayersCallbackInfo(Pointer peer) {
        super(peer);
    }

    public List<EOS_ProductUserId> getRegisteredPlayers() {
        if (this.RegisteredPlayers == null || this.RegisteredPlayersCount == 0) {
            return Collections.emptyList();
        }
        Pointer[] pointers = this.RegisteredPlayers.getPointerArray(0L, this.RegisteredPlayersCount);
        ArrayList<EOS_ProductUserId> players = new ArrayList<EOS_ProductUserId>(this.RegisteredPlayersCount);
        for (Pointer p : pointers) {
            EOS_ProductUserId userId = new EOS_ProductUserId();
            userId.setPointer(p);
            players.add(userId);
        }
        return players;
    }

    public List<EOS_ProductUserId> getSanctionedPlayers() {
        if (this.SanctionedPlayers == null || this.SanctionedPlayersCount == 0) {
            return Collections.emptyList();
        }
        Pointer[] pointers = this.SanctionedPlayers.getPointerArray(0L, this.SanctionedPlayersCount);
        ArrayList<EOS_ProductUserId> players = new ArrayList<EOS_ProductUserId>(this.SanctionedPlayersCount);
        for (Pointer p : pointers) {
            EOS_ProductUserId userId = new EOS_ProductUserId();
            userId.setPointer(p);
            players.add(userId);
        }
        return players;
    }

    public static class ByValue
    extends EOS_Sessions_RegisterPlayersCallbackInfo
    implements Structure.ByValue {
    }

    public static class ByReference
    extends EOS_Sessions_RegisterPlayersCallbackInfo
    implements Structure.ByReference {
    }
}

