/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.utils;

import com.sun.jna.Callback;
import com.sun.jna.Native;
import host.anzo.eossdk.eos.sdk.common.EOS_NotificationId;
import host.anzo.eossdk.eos.sdk.logging.callbacks.EOS_LogMessageFunc;
import host.anzo.eossdk.eos.utils.VMUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CallbackUtils.class);
    private static final Map<EOS_NotificationId, Callback> notificationCallbacks = new ConcurrentHashMap<EOS_NotificationId, Callback>();
    private static EOS_LogMessageFunc loggingCallback;

    public static void registerNotificationCallback(EOS_NotificationId notificationId, Callback callback) {
        if (VMUtils.DEBUG) {
            log.debug("Registered callback [{}] with id=[{}]", (Object)callback.getClass().getInterfaces()[0].getSimpleName(), (Object)notificationId);
        }
        notificationCallbacks.put(notificationId, callback);
    }

    public static void unregisterNotificationCallback(EOS_NotificationId notificationId) {
        Callback callback = notificationCallbacks.remove((Object)notificationId);
        if (callback != null && VMUtils.DEBUG) {
            log.debug("Unregistered callback [{}] with id=[{}]", (Object)callback.getClass().getInterfaces()[0].getSimpleName(), (Object)notificationId);
        }
    }

    public static void registerLoggingCallback(EOS_LogMessageFunc callback) {
        loggingCallback = callback;
    }

    public static void printNotificationCallbacks() {
        for (Map.Entry<EOS_NotificationId, Callback> entry : notificationCallbacks.entrySet()) {
            log.info("Registered callback [{}] with id=[{}]", (Object)entry.getValue().getClass().getInterfaces()[0].getSimpleName(), (Object)entry.getKey());
        }
    }

    static {
        Native.setCallbackExceptionHandler((c, e) -> log.error("Callback {} throws exception", (Object)c.getClass().getInterfaces()[0].getSimpleName(), (Object)e));
    }
}

