/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.sdk.playerdatastorage.EOS_PlayerDataStorageFileTransferRequest;
import host.anzo.eossdk.eos.sdk.playerdatastorage.EOS_PlayerDataStorage_FileMetadata;
import host.anzo.eossdk.eos.sdk.playerdatastorage.callbacks.EOS_PlayerDataStorage_OnDeleteCacheCompleteCallback;
import host.anzo.eossdk.eos.sdk.playerdatastorage.callbacks.EOS_PlayerDataStorage_OnDeleteFileCompleteCallback;
import host.anzo.eossdk.eos.sdk.playerdatastorage.callbacks.EOS_PlayerDataStorage_OnDuplicateFileCompleteCallback;
import host.anzo.eossdk.eos.sdk.playerdatastorage.callbacks.EOS_PlayerDataStorage_OnQueryFileCompleteCallback;
import host.anzo.eossdk.eos.sdk.playerdatastorage.callbacks.EOS_PlayerDataStorage_OnQueryFileListCompleteCallback;
import host.anzo.eossdk.eos.sdk.playerdatastorage.callbacks.EOS_PlayerDataStorage_OnReadFileCompleteCallback;
import host.anzo.eossdk.eos.sdk.playerdatastorage.callbacks.EOS_PlayerDataStorage_OnWriteFileCompleteCallback;
import host.anzo.eossdk.eos.sdk.playerdatastorage.options.EOS_PlayerDataStorage_CopyFileMetadataAtIndexOptions;
import host.anzo.eossdk.eos.sdk.playerdatastorage.options.EOS_PlayerDataStorage_CopyFileMetadataByFilenameOptions;
import host.anzo.eossdk.eos.sdk.playerdatastorage.options.EOS_PlayerDataStorage_DeleteCacheOptions;
import host.anzo.eossdk.eos.sdk.playerdatastorage.options.EOS_PlayerDataStorage_DeleteFileOptions;
import host.anzo.eossdk.eos.sdk.playerdatastorage.options.EOS_PlayerDataStorage_DuplicateFileOptions;
import host.anzo.eossdk.eos.sdk.playerdatastorage.options.EOS_PlayerDataStorage_GetFileMetadataCountOptions;
import host.anzo.eossdk.eos.sdk.playerdatastorage.options.EOS_PlayerDataStorage_QueryFileListOptions;
import host.anzo.eossdk.eos.sdk.playerdatastorage.options.EOS_PlayerDataStorage_QueryFileOptions;
import host.anzo.eossdk.eos.sdk.playerdatastorage.options.EOS_PlayerDataStorage_ReadFileOptions;
import host.anzo.eossdk.eos.sdk.playerdatastorage.options.EOS_PlayerDataStorage_WriteFileOptions;

public class EOS_PlayerDataStorage_Interface
extends PointerType {
    public static final int EOS_PLAYERDATASTORAGE_FILENAME_MAX_LENGTH_BYTES = 64;

    public EOS_PlayerDataStorage_Interface(Pointer address) {
        super(address);
    }

    public EOS_PlayerDataStorage_Interface() {
    }

    public void queryFile(EOS_PlayerDataStorage_QueryFileOptions queryFileOptions, Pointer clientData, EOS_PlayerDataStorage_OnQueryFileCompleteCallback completionCallback) {
        EOSLibrary.instance.EOS_PlayerDataStorage_QueryFile(this, queryFileOptions, clientData, completionCallback);
    }

    public void queryFileList(EOS_PlayerDataStorage_QueryFileListOptions queryFileListOptions, Pointer clientData, EOS_PlayerDataStorage_OnQueryFileListCompleteCallback completionCallback) {
        EOSLibrary.instance.EOS_PlayerDataStorage_QueryFileList(this, queryFileListOptions, clientData, completionCallback);
    }

    public EOS_PlayerDataStorage_FileMetadata copyFileMetadataByFilename(EOS_PlayerDataStorage_CopyFileMetadataByFilenameOptions copyFileMetadataOptions) throws EOSException {
        PointerByReference outMetadata = new PointerByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_PlayerDataStorage_CopyFileMetadataByFilename(this, copyFileMetadataOptions, outMetadata);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        EOS_PlayerDataStorage_FileMetadata metadata = new EOS_PlayerDataStorage_FileMetadata(outMetadata.getValue());
        metadata.read();
        return metadata;
    }

    public int getFileMetadataCount(EOS_PlayerDataStorage_GetFileMetadataCountOptions getFileMetadataCountOptions) throws EOSException {
        IntByReference outFileMetadataCount = new IntByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_PlayerDataStorage_GetFileMetadataCount(this, getFileMetadataCountOptions, outFileMetadataCount);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        return outFileMetadataCount.getValue();
    }

    public EOS_PlayerDataStorage_FileMetadata copyFileMetadataAtIndex(EOS_PlayerDataStorage_CopyFileMetadataAtIndexOptions copyFileMetadataOptions) throws EOSException {
        PointerByReference outMetadata = new PointerByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_PlayerDataStorage_CopyFileMetadataAtIndex(this, copyFileMetadataOptions, outMetadata);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        EOS_PlayerDataStorage_FileMetadata metadata = new EOS_PlayerDataStorage_FileMetadata(outMetadata.getValue());
        metadata.read();
        return metadata;
    }

    public void duplicateFile(EOS_PlayerDataStorage_DuplicateFileOptions duplicateOptions, Pointer clientData, EOS_PlayerDataStorage_OnDuplicateFileCompleteCallback completionCallback) {
        EOSLibrary.instance.EOS_PlayerDataStorage_DuplicateFile(this, duplicateOptions, clientData, completionCallback);
    }

    public void deleteFile(EOS_PlayerDataStorage_DeleteFileOptions deleteOptions, Pointer clientData, EOS_PlayerDataStorage_OnDeleteFileCompleteCallback completionCallback) {
        EOSLibrary.instance.EOS_PlayerDataStorage_DeleteFile(this, deleteOptions, clientData, completionCallback);
    }

    public EOS_PlayerDataStorageFileTransferRequest readFile(EOS_PlayerDataStorage_ReadFileOptions readOptions, Pointer clientData, EOS_PlayerDataStorage_OnReadFileCompleteCallback completionCallback) {
        return EOSLibrary.instance.EOS_PlayerDataStorage_ReadFile(this, readOptions, clientData, completionCallback);
    }

    public EOS_PlayerDataStorageFileTransferRequest writeFile(EOS_PlayerDataStorage_WriteFileOptions writeOptions, Pointer clientData, EOS_PlayerDataStorage_OnWriteFileCompleteCallback completionCallback) {
        return EOSLibrary.instance.EOS_PlayerDataStorage_WriteFile(this, writeOptions, clientData, completionCallback);
    }

    public EOS_EResult deleteCache(EOS_PlayerDataStorage_DeleteCacheOptions options, Pointer clientData, EOS_PlayerDataStorage_OnDeleteCacheCompleteCallback completionCallback) {
        return EOSLibrary.instance.EOS_PlayerDataStorage_DeleteCache(this, options, clientData, completionCallback);
    }
}

