/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.eossdk.eos.sdk;

import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.ptr.PointerByReference;
import host.anzo.eossdk.eos.exceptions.EOSException;
import host.anzo.eossdk.eos.sdk.EOSLibrary;
import host.anzo.eossdk.eos.sdk.common.enums.EOS_EResult;
import host.anzo.eossdk.eos.sdk.stats.EOS_Stats_Stat;
import host.anzo.eossdk.eos.sdk.stats.callbacks.EOS_Stats_OnIngestStatCompleteCallback;
import host.anzo.eossdk.eos.sdk.stats.callbacks.EOS_Stats_OnQueryStatsCompleteCallback;
import host.anzo.eossdk.eos.sdk.stats.options.EOS_Stats_CopyStatByIndexOptions;
import host.anzo.eossdk.eos.sdk.stats.options.EOS_Stats_CopyStatByNameOptions;
import host.anzo.eossdk.eos.sdk.stats.options.EOS_Stats_GetStatCountOptions;
import host.anzo.eossdk.eos.sdk.stats.options.EOS_Stats_IngestStatOptions;
import host.anzo.eossdk.eos.sdk.stats.options.EOS_Stats_QueryStatsOptions;

public class EOS_Stats_Interface
extends PointerType {
    public EOS_Stats_Interface(Pointer address) {
        super(address);
    }

    public EOS_Stats_Interface() {
    }

    public void ingestStat(EOS_Stats_IngestStatOptions options, Pointer clientData, EOS_Stats_OnIngestStatCompleteCallback completionDelegate) {
        EOSLibrary.instance.EOS_Stats_IngestStat(this, options, clientData, completionDelegate);
    }

    public void queryStats(EOS_Stats_QueryStatsOptions options, Pointer clientData, EOS_Stats_OnQueryStatsCompleteCallback completionDelegate) {
        EOSLibrary.instance.EOS_Stats_QueryStats(this, options, clientData, completionDelegate);
    }

    public int getStatsCount(EOS_Stats_GetStatCountOptions options) {
        return EOSLibrary.instance.EOS_Stats_GetStatsCount(this, options);
    }

    public EOS_Stats_Stat copyStatByIndex(EOS_Stats_CopyStatByIndexOptions options) throws EOSException {
        PointerByReference outStat = new PointerByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_Stats_CopyStatByIndex(this, options, outStat);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        EOS_Stats_Stat stat = new EOS_Stats_Stat(outStat.getValue());
        stat.read();
        return stat;
    }

    public EOS_Stats_Stat copyStatByName(EOS_Stats_CopyStatByNameOptions options) throws EOSException {
        PointerByReference outStat = new PointerByReference();
        EOS_EResult result = EOSLibrary.instance.EOS_Stats_CopyStatByName(this, options, outStat);
        if (!result.isSuccess()) {
            throw EOSException.fromResult(result);
        }
        EOS_Stats_Stat stat = new EOS_Stats_Stat(outStat.getValue());
        stat.read();
        return stat;
    }
}

