/*
 * Decompiled with CFR 0.152.
 */
package express.filter;

import express.http.HttpRequestHandler;
import express.http.request.Request;
import express.http.response.Response;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class FilterImpl
implements HttpRequestHandler {
    private final HttpRequestHandler request;
    private final String req;
    private final String context;
    private final boolean reqAll;
    private final boolean contextAll;
    private String root;
    private String fullContext;

    public FilterImpl(String requestMethod, String context, HttpRequestHandler httpRequest) {
        this.req = requestMethod;
        this.request = httpRequest;
        this.context = this.normalizePath(context);
        this.reqAll = requestMethod.equals("*");
        this.contextAll = context.equals("*");
        this.root = "/";
        this.fullContext = this.context;
    }

    public void setRoot(String root) {
        if (root == null || ((String)root).isEmpty()) {
            return;
        }
        if (((String)root).charAt(0) != '/') {
            root = "/" + (String)root;
        }
        if (((String)root).charAt(((String)root).length() - 1) != '/') {
            root = (String)root + "/";
        }
        this.root = this.normalizePath((String)root);
        this.fullContext = this.normalizePath(this.root + this.context);
    }

    @Override
    public void handle(Request req, Response res) {
        String requestMethod = req.getMethod();
        String requestPath = req.getURI().getRawPath();
        ConcurrentHashMap<String, HttpRequestHandler> parameterListener = req.getApp().getParameterListener();
        if (!this.reqAll && !this.req.equals(requestMethod)) {
            return;
        }
        if (this.contextAll) {
            req.setContext(this.context);
            this.request.handle(req, res);
            return;
        }
        HashMap<String, String> params = this.matchURL(this.fullContext, requestPath);
        if (params == null) {
            return;
        }
        req.setParams(params);
        params.forEach((s, s2) -> {
            HttpRequestHandler request = (HttpRequestHandler)parameterListener.get(s);
            if (request != null) {
                request.handle(req, res);
            }
        });
        if (res.isClosed()) {
            return;
        }
        req.setContext(this.context);
        this.request.handle(req, res);
    }

    private HashMap<String, String> matchURL(String filter, String url) {
        int fi;
        HashMap<String, String> params = new HashMap<String, String>();
        StringBuilder key = new StringBuilder();
        StringBuilder val = new StringBuilder();
        char[] uc = url.toCharArray();
        char[] fc = filter.toCharArray();
        int ui = 0;
        for (fi = 0; fi < fc.length && ui < uc.length; ++fi, ++ui) {
            if (fc[fi] == ':') {
                key.setLength(0);
                val.setLength(0);
                ++fi;
                while (fi < fc.length && fc[fi] != '/') {
                    key.append(fc[fi++]);
                }
                while (ui < uc.length && uc[ui] != '/') {
                    val.append(uc[ui++]);
                }
                String decVal = URLDecoder.decode(val.toString(), StandardCharsets.UTF_8);
                params.put(key.toString(), decVal);
                continue;
            }
            if (fc[fi] == uc[ui]) continue;
            return null;
        }
        if (ui < url.length() || fi < filter.length()) {
            return null;
        }
        return params;
    }

    private String normalizePath(String context) {
        if (context == null || context.length() == 1) {
            return context;
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = context.toCharArray();
        sb.append(chars[0]);
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i] == '/' && chars[i - 1] == '/') continue;
            sb.append(chars[i]);
        }
        return sb.toString();
    }
}

