/*
 * Decompiled with CFR 0.152.
 */
package express.http.request;

import com.sun.net.httpserver.Headers;
import express.http.Cookie;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

final class RequestUtils {
    private RequestUtils() {
    }

    static HashMap<String, Cookie> parseCookies(Headers headers) {
        HashMap<String, Cookie> cookieList = new HashMap<String, Cookie>();
        Object headerCookies = headers.get("Cookie");
        if (headerCookies == null || headerCookies.isEmpty()) {
            return cookieList;
        }
        char[] chars = ((String)headerCookies.get(0)).toCharArray();
        StringBuilder key = new StringBuilder();
        StringBuilder val = new StringBuilder();
        boolean swap = false;
        for (char c : chars) {
            if (c == '=') {
                swap = true;
                continue;
            }
            if (c == ';') {
                String rkey = key.toString().trim();
                cookieList.put(rkey, new Cookie(rkey, val.toString()));
                key.setLength(0);
                val.setLength(0);
                swap = false;
                continue;
            }
            if (swap) {
                val.append(c);
                continue;
            }
            key.append(c);
        }
        if (key.length() > 0 && val.length() > 0) {
            String rkey = key.toString().trim();
            cookieList.put(rkey, new Cookie(rkey, val.toString()));
        }
        return cookieList;
    }

    static HashMap<String, String> parseRawQuery(String rawQuery) {
        HashMap<String, String> querys = new HashMap<String, String>();
        if (rawQuery == null) {
            return querys;
        }
        StringBuilder key = new StringBuilder();
        StringBuilder val = new StringBuilder();
        char[] chars = rawQuery.toCharArray();
        boolean keyac = false;
        char c = '=';
        for (char cc : chars) {
            c = cc;
            if (c == '=') {
                keyac = true;
                continue;
            }
            if (c == '&') {
                querys.put(URLDecoder.decode(key.toString(), StandardCharsets.UTF_8), URLDecoder.decode(val.toString(), StandardCharsets.UTF_8));
                key.setLength(0);
                val.setLength(0);
                keyac = false;
                continue;
            }
            if (keyac) {
                val.append(c);
                continue;
            }
            key.append(c);
        }
        if (c != '=' && c != '&') {
            querys.put(key.toString(), val.toString());
        }
        return querys;
    }
}

