/*
 * Decompiled with CFR 0.152.
 */
package express.middleware;

import express.http.HttpRequestHandler;
import express.http.request.Request;
import express.http.response.Response;
import express.middleware.FileProviderOptions;
import express.utils.Status;
import express.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FileProvider
implements HttpRequestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(FileProvider.class);
    private FileProviderOptions options;
    private String root;

    FileProvider(String root, FileProviderOptions options) throws IOException {
        Path rootDir = Paths.get(root, new String[0]);
        if (!Files.exists(rootDir, new LinkOption[0]) || !Files.isDirectory(rootDir, new LinkOption[0])) {
            throw new IOException(String.valueOf(rootDir) + " does not exists or isn't a directory.");
        }
        this.root = rootDir.toAbsolutePath().toString();
        this.options = options;
    }

    @Override
    public void handle(Request req, Response res) {
        try {
            String path = req.getURI().getPath();
            String context = req.getContext();
            if (path.indexOf(context) == 0) {
                path = path.substring(context.length());
            }
            if (path.length() <= 1) {
                path = "index.html";
            }
            Path reqFile = Paths.get(this.root + File.separator + path, new String[0]);
            if (this.options.isFallBackSearching() && !Files.exists(reqFile, new LinkOption[0]) && !Files.isDirectory(reqFile, new LinkOption[0])) {
                String name = reqFile.getFileName().toString();
                try {
                    Optional<Path> founded;
                    Path parent = reqFile.getParent();
                    if (Files.isReadable(parent) && (founded = Files.walk(parent, new FileVisitOption[0]).filter(sub -> this.getBaseName((Path)sub).equals(name)).findFirst()).isPresent()) {
                        reqFile = founded.get();
                    }
                }
                catch (IOException e) {
                    log.error("Cannot walk file tree.", (Throwable)e);
                }
            }
            if (Files.exists(reqFile, new LinkOption[0]) && Files.isRegularFile(reqFile, new LinkOption[0])) {
                if (reqFile.getFileName().toString().charAt(0) == '.') {
                    switch (this.options.getDotFiles()) {
                        case IGNORE: {
                            res.setStatus(Status._404);
                            return;
                        }
                        case DENY: {
                            res.setStatus(Status._403);
                            return;
                        }
                    }
                }
                if (this.options.getExtensions() != null) {
                    String reqEx = Utils.getExtension(reqFile);
                    if (reqEx == null) {
                        return;
                    }
                    for (String ex : this.options.getExtensions()) {
                        if (!reqEx.equals(ex)) continue;
                        this.finish(reqFile, req, res);
                        break;
                    }
                    res.setStatus(Status._403);
                } else {
                    this.finish(reqFile, req, res);
                }
            }
        }
        catch (Exception e) {
            log.error("handle", (Throwable)e);
        }
    }

    private void finish(Path file, Request req, Response res) {
        if (this.options.getHandler() != null) {
            this.options.getHandler().handle(req, res);
        }
        try {
            if (this.options.isLastModified()) {
                Instant instant = Instant.ofEpochMilli(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis());
                DateTimeFormatter formatter = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneOffset.UTC);
                res.setHeader("Last-Modified", formatter.format(instant));
            }
        }
        catch (IOException e) {
            res.sendStatus(Status._500);
            log.error("Cannot read LastModifiedTime from file [{}]", (Object)file.toString(), (Object)e);
            return;
        }
        res.setHeader("Cache-Control", String.valueOf(this.options.getMaxAge()));
        res.send(file);
    }

    private String getBaseName(Path path) {
        String name = path.getFileName().toString();
        int index = name.lastIndexOf(46);
        return index == -1 ? name : name.substring(0, index);
    }
}

