/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.Dispatcher;
import host.anzo.simon.NamedThreadPoolFactory;
import host.anzo.simon.utils.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingWatchdog {
    private static final Logger log = LoggerFactory.getLogger(PingWatchdog.class);
    private static final int WAIT_FOR_WAITRUNNABLE_TIMEOUT = 10000;
    Map<IoSession, WaitRunnable> sessionWaitrunnableMap = Collections.synchronizedMap(new HashMap());
    ExecutorService pingWatchdogPool = Executors.newCachedThreadPool(new NamedThreadPoolFactory("Simon.Dispatcher.PingWatchdogPool"));
    private Dispatcher dispatcher;

    protected PingWatchdog(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected void waitForPong(IoSession session) {
        log.debug("Waiting for pong for session: {}", (Object)Utils.longToHexString(session.getId()));
        WaitRunnable runnable = new WaitRunnable(session);
        this.sessionWaitrunnableMap.put(session, runnable);
        this.pingWatchdogPool.execute(runnable);
    }

    protected void notifyPongReceived(IoSession session) {
        log.debug("Pong received for session: {}", (Object)Utils.longToHexString(session.getId()));
        WaitRunnable waitRunnable = this.sessionWaitrunnableMap.remove(session);
        if (waitRunnable != null) {
            waitRunnable.pongReceived();
        } else {
            log.warn("waitRunnable for session {} not present. Waiting for it ...", (Object)Utils.longToHexString(session.getId()));
            long totallyWaited = 0L;
            while (!this.sessionWaitrunnableMap.containsKey(session) || totallyWaited < 10000L) {
                try {
                    long start = System.currentTimeMillis();
                    Thread.sleep(200L);
                    totallyWaited += System.currentTimeMillis() - start;
                }
                catch (InterruptedException e) {
                    log.debug("sleeping interrupted! exiting wait loop.");
                    totallyWaited = 10000L;
                }
            }
            if (this.sessionWaitrunnableMap.containsKey(session)) {
                log.debug("now WaitRunnable for session {} is present. notify pong received again.", (Object)session);
                this.notifyPongReceived(session);
            } else {
                log.error("waitRunnable for session {} after {} ms still not present. aborting pong notify.", (Object)Utils.longToHexString(session.getId()), (Object)10000);
            }
        }
    }

    class WaitRunnable
    implements Runnable {
        private IoSession session;
        private int timeout;
        private final Object monitor = new Object();
        private boolean pongReceived = false;

        public WaitRunnable(IoSession session) {
            this.session = session;
            this.timeout = PingWatchdog.this.dispatcher.getPingTimeout() * 1000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long end;
            log.debug("begin. sleeping {} ms before timout will occur. monitor={}", (Object)this.timeout, this.monitor);
            long start = System.currentTimeMillis();
            if (!this.pongReceived) {
                Object object = this.monitor;
                synchronized (object) {
                    try {
                        this.monitor.wait(this.timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            boolean withinTime = (end = System.currentTimeMillis()) - start < (long)this.timeout;
            long remaining = (long)this.timeout - (end - start);
            long sleepTime = end - start;
            if (this.pongReceived) {
                if (withinTime) {
                    log.trace("Pong for session {} and monitor {} received within time! remaining={} rtt={}", new Object[]{Utils.longToHexString(this.session.getId()), this.monitor, remaining, sleepTime});
                } else {
                    log.warn("Pong for session {} and monitor {} received, but NOT WITHIN TIME! remaining={} rtt={}", new Object[]{Utils.longToHexString(this.session.getId()), this.monitor, remaining, sleepTime});
                    this.closeSession();
                }
            } else {
                log.trace("Pong for session {} and monitor {} not received", (Object)Utils.longToHexString(this.session.getId()), this.monitor);
                this.closeSession();
            }
            log.debug("end.");
        }

        private void closeSession() {
            log.debug("PingPong failure for session session {} and monitor {}. Closing it immediately.", (Object)Utils.longToHexString(this.session.getId()), this.monitor);
            this.session.closeNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pongReceived() {
            log.debug("Pong received for session {}. Notify monitor {}", (Object)Utils.longToHexString(this.session.getId()), this.monitor);
            this.pongReceived = true;
            Object object = this.monitor;
            synchronized (object) {
                this.monitor.notifyAll();
            }
        }
    }
}

