/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.SimonPublication;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublishService
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(PublishService.class);
    private MulticastSocket socket;
    private InetAddress groupAddress = InetAddress.getByName("239.1.2.3");
    private int groupPort = 4753;
    private boolean shutdown;
    private List<SimonPublication> publishments;

    protected PublishService(List<SimonPublication> publishments) throws IOException {
        log.debug("preparing publish service");
        this.setName("Simon.PublishService");
        this.socket = new MulticastSocket(this.groupPort);
        this.socket.joinGroup(this.groupAddress);
        this.socket.setSoTimeout(100);
        this.publishments = publishments;
    }

    @Override
    public void run() {
        log.debug("publish service up and running");
        while (!this.shutdown) {
            try {
                byte[] searchData = new byte["[SIMON|FindServer]".length()];
                DatagramPacket searchPacket = new DatagramPacket(searchData, searchData.length);
                this.socket.receive(searchPacket);
                InetAddress requestAddress = searchPacket.getAddress();
                int requestPort = searchPacket.getPort();
                String requestString = new String(searchPacket.getData());
                log.debug("got 'find server' request. requestHost=" + requestAddress + " requestPort=" + requestPort + " requestString=" + requestString);
                if (!requestString.equals("[SIMON|FindServer]")) continue;
                for (SimonPublication publishment : this.publishments) {
                    log.debug("answering: " + publishment);
                    byte[] answerData = publishment.toString().getBytes();
                    DatagramPacket answerPacket = new DatagramPacket(answerData, answerData.length, requestAddress, this.groupPort - 1);
                    this.socket.send(answerPacket);
                }
            }
            catch (SocketTimeoutException searchData) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.socket.close();
        log.debug("publish service terminated!");
    }

    protected void shutdown() {
        this.shutdown = true;
        log.debug("Shutting down the publish service now ...");
    }
}

