/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import host.anzo.simon.RawChannelDataListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.ByteBuffer;

public class RawChannelInputStream
extends InputStream {
    private RawChannelDataListener dataListener = new RawChannelDataListener(){

        @Override
        public void write(ByteBuffer data) {
            int len = data.limit();
            data.get(RawChannelInputStream.this.buf, 0, len);
            try {
                RawChannelInputStream.this.pos.write(RawChannelInputStream.this.buf, 0, len);
            }
            catch (IOException ex) {
                RawChannelInputStream.this.exception = ex;
            }
        }

        @Override
        public void close() {
            try {
                RawChannelInputStream.this.pos.close();
            }
            catch (IOException ex) {
                RawChannelInputStream.this.exception = ex;
            }
        }
    };
    private IOException exception;
    private PipedInputStream pis;
    private PipedOutputStream pos;
    private final byte[] buf;
    public static final int DEFAULT_BLOCKSIZE = 8192;

    public RawChannelInputStream() throws IOException {
        this(8192);
    }

    public RawChannelInputStream(int blockSize) throws IOException {
        this.buf = new byte[blockSize];
        this.pos = new PipedOutputStream();
        this.pis = new PipedInputStream(this.pos, blockSize);
    }

    @Override
    public int read() throws IOException {
        if (this.exception != null) {
            throw new IOException("Error occured while forwarding data from RawChannelDataListener to InputStream", this.exception);
        }
        return this.pis.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.exception != null) {
            throw new IOException("Error occured while forwarding data from RawChannelDataListener to InputStream", this.exception);
        }
        return this.pis.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.exception != null) {
            throw new IOException("Error occured while forwarding data from RawChannelDataListener to InputStream", this.exception);
        }
        return this.pis.read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.exception != null) {
            throw new IOException("Error occured while forwarding data from RawChannelDataListener to InputStream", this.exception);
        }
        this.pis.reset();
    }

    @Override
    public int available() throws IOException {
        if (this.exception != null) {
            throw new IOException("Error occured while forwarding data from RawChannelDataListener to InputStream", this.exception);
        }
        return this.pis.available();
    }

    @Override
    public void close() throws IOException {
        if (this.exception != null) {
            throw new IOException("Error occured while forwarding data from RawChannelDataListener to InputStream", this.exception);
        }
        this.pos.close();
        this.pis.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.pis.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.pis.markSupported();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.exception != null) {
            throw new IOException("Error occured while forwarding data from RawChannelDataListener to InputStream", this.exception);
        }
        return this.pis.skip(n);
    }

    public RawChannelDataListener getRawChannelDataListener() {
        return this.dataListener;
    }
}

