/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimonPublication {
    private static final Logger log = LoggerFactory.getLogger(SimonPublication.class);
    private static final String SIMON_PUBLISHMENT_HEADER = "[SIMON|";
    private String remoteObjectName;
    private int port;
    private InetAddress address;
    private StringBuffer sb = new StringBuffer();

    protected SimonPublication(InetAddress address, int port, String remoteObjectName) {
        if (address.getHostAddress().equalsIgnoreCase("0.0.0.0")) {
            log.trace("Given IP is 0.0.0.0... Searching for a better one ...");
            boolean ipFound = false;
            try {
                Enumeration<NetworkInterface> netInter = NetworkInterface.getNetworkInterfaces();
                int n = 0;
                while (netInter.hasMoreElements()) {
                    NetworkInterface ni = netInter.nextElement();
                    log.trace("Analyzing: NetworkInterface #{}: {}", (Object)n++, (Object)ni.getDisplayName());
                    for (InetAddress iaddress : Collections.list(ni.getInetAddresses())) {
                        if (!(iaddress instanceof Inet4Address) || iaddress.isLoopbackAddress()) continue;
                        log.trace("choosing {} instead of 0.0.0.0", (Object)iaddress.getHostAddress());
                        address = iaddress;
                        ipFound = true;
                        break;
                    }
                    if (!ipFound) continue;
                    break;
                }
                if (!ipFound) {
                    log.error("no suiteable IP found. Still working with IP 0.0.0.0 which can't be used by clients!");
                }
            }
            catch (SocketException e) {
                log.error("Error while detecting IP address. Error was: {}", (Object)e.getMessage());
            }
            log.trace("end with search");
        }
        this.address = address;
        this.port = port;
        this.remoteObjectName = remoteObjectName;
    }

    protected SimonPublication(String rawString) throws IllegalArgumentException, UnknownHostException, NumberFormatException {
        if (!rawString.substring(0, SIMON_PUBLISHMENT_HEADER.length()).equals(SIMON_PUBLISHMENT_HEADER) && !rawString.substring(SIMON_PUBLISHMENT_HEADER.length() - 1, SIMON_PUBLISHMENT_HEADER.length()).equals("]")) {
            throw new IllegalArgumentException("provided raw string has the wrong format: " + rawString);
        }
        String values = rawString.substring(SIMON_PUBLISHMENT_HEADER.length(), rawString.length() - 1);
        String[] valuesSplit = values.split("\\|");
        if (valuesSplit.length != 2) {
            throw new IllegalArgumentException("except the header, there must be two values in the raw string. 1st: 'ip:port' 2nd: 'remoteObjectName'. values=" + values);
        }
        String[] addressSplit = valuesSplit[0].split(":");
        if (addressSplit.length != 2) {
            throw new IllegalArgumentException("the address value must contain two values: 1st: 'ip' 2nd: 'port'.");
        }
        this.address = InetAddress.getByName(addressSplit[0]);
        this.port = Integer.parseInt(addressSplit[1]);
        if (valuesSplit[1] == null || valuesSplit[1].length() < 1) {
            throw new IllegalArgumentException("'remoteObjectName' must not be 'null' or zero-length.");
        }
        this.remoteObjectName = valuesSplit[1];
    }

    public String getRemoteObjectName() {
        return this.remoteObjectName;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public String toString() {
        this.sb.delete(0, this.sb.length());
        this.sb.append(SIMON_PUBLISHMENT_HEADER);
        this.sb.append(this.address.getHostAddress());
        this.sb.append(":");
        this.sb.append(this.port);
        this.sb.append("|");
        this.sb.append(this.remoteObjectName);
        this.sb.append("]");
        return this.sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimonPublication) {
            SimonPublication other = (SimonPublication)obj;
            return this.getAddress().equals(other.getAddress()) && this.getPort() == other.getPort() && this.getRemoteObjectName().equals(other.getRemoteObjectName());
        }
        return false;
    }
}

