/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec;

import host.anzo.simon.SimonProxyConfig;
import host.anzo.simon.utils.FilterEntry;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.util.Base64;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimonProxyFilter
extends IoFilterAdapter {
    private static final Logger log = LoggerFactory.getLogger(SimonProxyFilter.class);
    public static final String FILTER_NAME = SimonProxyFilter.class.getName();
    private boolean okReceived;
    private String targetHost;
    private int targetPort;
    private boolean authRequired;
    private String username;
    private String password;
    private String receivedAnswerMsg = "";
    private List<FilterEntry> filters;

    public SimonProxyFilter(String targetHost, int targetPort, @NotNull SimonProxyConfig proxyConfig, List<FilterEntry> backupChain) {
        this.targetHost = targetHost;
        this.targetPort = targetPort;
        this.authRequired = proxyConfig.isAuthRequired();
        this.username = proxyConfig.getUsername();
        this.password = proxyConfig.getPassword();
        this.filters = backupChain;
        log.debug("Proxyfilter loaded");
    }

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        log.debug("session created: {}", (Object)session);
        IoFilterChain filterChain = session.getFilterChain();
        filterChain.clear();
        if (log.isTraceEnabled()) {
            filterChain.addLast(LoggingFilter.class.getName(), (IoFilter)new LoggingFilter());
        }
        filterChain.addLast(TextLineCodecFactory.class.getName(), (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory(Charset.forName("UTF-8"))));
        filterChain.addLast(((Object)((Object)this)).getClass().getName(), (IoFilter)this);
        log.trace("ready for proxy connection. chain is now: {}", (Object)filterChain);
        log.debug("sending proxy connect request");
        session.write((Object)("CONNECT " + this.targetHost + ":" + this.targetPort + " HTTP/1.1"));
        if (this.authRequired) {
            session.write((Object)("Host: " + this.targetHost + ":" + this.targetPort));
            session.write((Object)("Proxy-Authorization: Basic " + new String(Base64.encodeBase64((byte[])(this.username + ":" + this.password).getBytes())) + "\n"));
        } else {
            session.write((Object)("Host: " + this.targetHost + ":" + this.targetPort + "\n"));
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        log.debug("message=" + message);
        this.receivedAnswerMsg = this.receivedAnswerMsg + message + "\n";
        if (message.toString().contains("HTTP/1.1 200")) {
            log.debug("OK detected");
            this.okReceived = true;
        }
        if (message.toString().equals("")) {
            if (this.okReceived) {
                log.debug("rest of OK header received. restore 'normal' filterchain");
                session.getFilterChain().clear();
                for (FilterEntry relation : this.filters) {
                    session.getFilterChain().addLast(relation.name, relation.filter);
                }
                log.trace("restored. chain is now: {}", (Object)session.getFilterChain());
                session.getFilterChain().fireSessionCreated();
            } else {
                throw new Exception("Creating tunnel failed. Answer from proxyserver was: \n" + this.receivedAnswerMsg);
            }
        }
    }
}

