/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import java.io.Serializable;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoder;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageDecoder
implements MessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(AbstractMessageDecoder.class);
    private final byte msgType;
    private int sequence;
    private int bodysize;
    private boolean readHeader;

    protected AbstractMessageDecoder(byte msgType) {
        this.msgType = msgType;
    }

    public MessageDecoderResult decodable(IoSession session, IoBuffer in) {
        if (in.remaining() < 9) {
            log.trace("Header not received completely. Right now we have {} of {} bytes", (Object)in.remaining(), (Object)9);
            return MessageDecoderResult.NEED_DATA;
        }
        byte type = in.get();
        if (this.msgType == type) {
            return MessageDecoderResult.OK;
        }
        return MessageDecoderResult.NOT_OK;
    }

    public MessageDecoderResult decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        if (!this.readHeader) {
            in.get();
            this.sequence = in.getInt();
            this.bodysize = in.getInt();
            this.readHeader = true;
        }
        if (in.remaining() < this.bodysize) {
            log.trace("Message type [{}] with sequence [{}] needs [{}] bytes. Right now we only have [{}]. Waiting for more ...", new Object[]{this.msgType, this.sequence, this.bodysize, in.remaining()});
            return MessageDecoderResult.NEED_DATA;
        }
        log.trace("Message type [{}] with sequence [{}] with [{}] bytes body size is available. Now decoding ...", new Object[]{this.msgType, this.sequence, this.bodysize});
        try {
            AbstractMessage m = this.decodeBody(session, in);
            if (m == null) {
                return MessageDecoderResult.NEED_DATA;
            }
            this.readHeader = false;
            m.setSequence(this.sequence);
            log.trace("finished decoding complete message: {}. Forwarding to next layer ...", (Object)m);
            out.write((Object)m);
            return MessageDecoderResult.OK;
        }
        catch (Throwable t) {
            log.trace("Error while decoding message. Forwarding/returning error.", t);
            MsgError m = new MsgError();
            m.setErrorMessage("Error while decoding message. sequence=" + this.sequence + " bodySize=" + this.bodysize + " type=" + (Serializable)(this.msgType == -1 ? "{unknown}" : Byte.valueOf(this.msgType)));
            m.setRemoteObjectName(null);
            m.setThrowable(t);
            out.write((Object)m);
            return MessageDecoderResult.NOT_OK;
        }
    }

    protected abstract AbstractMessage decodeBody(IoSession var1, IoBuffer var2);

    protected int getCurrentSequence() {
        return this.sequence;
    }

    protected int getBodySize() {
        return this.bodysize;
    }
}

