/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.MsgErrorEncoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.exceptions.SimonException;
import java.io.Serializable;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.apache.mina.filter.codec.demux.MessageEncoder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageEncoder<T extends AbstractMessage>
implements MessageEncoder<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMessageEncoder.class);
    private MsgError msgError = null;

    public void encode(IoSession session, T message, ProtocolEncoderOutput out) throws Exception {
        IoBuffer buf = null;
        try {
            buf = this.putMessageToBuffer(session, message);
        }
        catch (Throwable t) {
            if (buf != null) {
                buf.clear();
            }
            MsgError error = new MsgError();
            error.setErrorMessage("Error while encoding message. sequence=" + ((AbstractMessage)message).getSequence() + " type=" + (Serializable)(((AbstractMessage)message).getMsgType() == -1 ? "{unknown}" : Byte.valueOf(((AbstractMessage)message).getMsgType())));
            error.setInitSequenceId(((AbstractMessage)message).getSequence());
            error.setEncodeError();
            buf = this.putMessageToBuffer(session, message);
            this.msgError = error;
        }
        out.write((Object)buf);
        if (this.msgError != null) {
            session.closeOnFlush();
            String remoteObjectName = this.msgError.getRemoteObjectName();
            String errorMessage = this.msgError.getErrorMessage();
            Throwable throwable = this.msgError.getThrowable();
            String exceptionMessage = remoteObjectName != null && remoteObjectName.length() > 0 ? "An error occured on remote while writing a message to remote object '" + remoteObjectName + "'. Error message: " + errorMessage : "An error occured on remote while writing a message. Error message: " + errorMessage;
            SimonException se = new SimonException(exceptionMessage);
            se.initCause(throwable);
        }
    }

    @NotNull
    private IoBuffer putMessageToBuffer(IoSession session, T message) {
        IoBuffer msgBuffer = IoBuffer.allocate((int)16);
        msgBuffer.setAutoExpand(true);
        this.encodeBody(session, message, msgBuffer);
        IoBuffer buf = IoBuffer.allocate((int)(9 + msgBuffer.position()));
        buf.put(((AbstractMessage)message).getMsgType());
        buf.putInt(((AbstractMessage)message).getSequence());
        buf.putInt(msgBuffer.position());
        log.trace("Sending msg type [{}] with sequence [{}] and bodysize [{}] to next layer ...", new Object[]{((AbstractMessage)message).getMsgType(), ((AbstractMessage)message).getSequence(), msgBuffer.position()});
        msgBuffer.flip();
        buf.put(msgBuffer);
        buf.flip();
        return buf;
    }

    protected abstract void encodeBody(IoSession var1, T var2, IoBuffer var3);

    void sendEncodingError(@NotNull IoBuffer out, IoSession session, MsgError error) {
        out.clear();
        MsgErrorEncoder<MsgError> mee = new MsgErrorEncoder<MsgError>();
        mee.encodeBody(session, error, out);
        this.msgError = error;
    }
}

