/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageEncoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.codec.messages.MsgHashCode;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgHashCodeEncoder<T extends MsgHashCode>
extends AbstractMessageEncoder<T> {
    private static final Logger log = LoggerFactory.getLogger(MsgHashCodeEncoder.class);

    @Override
    protected void encodeBody(IoSession session, T message, IoBuffer out) {
        log.trace("begin. message={}", message);
        try {
            out.putPrefixedString((CharSequence)((MsgHashCode)message).getRemoteObjectName(), Charset.forName("UTF-8").newEncoder());
        }
        catch (CharacterCodingException e) {
            MsgError error = new MsgError();
            error.setEncodeError();
            error.setErrorMessage("Error while encoding hashCode() request: Not able to write remote object name '" + ((MsgHashCode)message).getRemoteObjectName() + "' due to CharacterCodingException.");
            error.setRemoteObjectName(((MsgHashCode)message).getRemoteObjectName());
            error.setInitSequenceId(((AbstractMessage)message).getSequence());
            error.setThrowable(e);
            this.sendEncodingError(out, session, error);
        }
        log.trace("end");
    }
}

