/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageDecoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.codec.messages.MsgHashCodeReturn;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgHashCodeReturnDecoder
extends AbstractMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(MsgHashCodeReturnDecoder.class);

    public MsgHashCodeReturnDecoder() {
        super((byte)9);
    }

    @Override
    protected AbstractMessage decodeBody(IoSession session, IoBuffer in) {
        MsgHashCodeReturn message = new MsgHashCodeReturn();
        try {
            message.setReturnValue(in.getInt());
            message.setErrorMsg(in.getPrefixedString(Charset.forName("UTF-8").newDecoder()));
        }
        catch (CharacterCodingException e) {
            MsgError error = new MsgError();
            error.setErrorMessage("Error while decoding hashCode() return: Not able to read remote object name due to CharacterCodingException.");
            error.setRemoteObjectName(null);
            error.setThrowable(e);
            return error;
        }
        log.trace("message={}", (Object)message);
        return message;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }
}

