/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageDecoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.codec.messages.MsgInterfaceLookup;
import host.anzo.simon.utils.Utils;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgInterfaceLookupDecoder
extends AbstractMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(MsgInterfaceLookupDecoder.class);

    public MsgInterfaceLookupDecoder() {
        super((byte)18);
    }

    @Override
    protected AbstractMessage decodeBody(IoSession session, IoBuffer in) {
        MsgInterfaceLookup m = new MsgInterfaceLookup();
        try {
            String canonicalInterfaceName = in.getPrefixedString(Charset.forName("UTF-8").newDecoder());
            m.setCanonicalInterfaceName(canonicalInterfaceName);
        }
        catch (CharacterCodingException e) {
            MsgError error = new MsgError();
            error.setErrorMessage("Error while decoding interrace lookup: Not able to read interface name due to CharacterCodingException.");
            error.setRemoteObjectName(null);
            error.setThrowable(e);
            return error;
        }
        if (log.isTraceEnabled()) {
            log.trace("message={} on session={}", (Object)m, (Object)Utils.longToHexString(session.getId()));
        }
        return m;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }
}

