/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageEncoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.codec.messages.MsgInterfaceLookup;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgInterfaceLookupEncoder<T extends MsgInterfaceLookup>
extends AbstractMessageEncoder<T> {
    private static final Logger log = LoggerFactory.getLogger(MsgInterfaceLookupEncoder.class);

    @Override
    protected void encodeBody(IoSession session, T message, IoBuffer out) {
        log.trace("begin. message={}", message);
        log.trace("position before: {}", (Object)out.position());
        try {
            out.putPrefixedString((CharSequence)((MsgInterfaceLookup)message).getCanonicalInterfaceName(), Charset.forName("UTF-8").newEncoder());
        }
        catch (CharacterCodingException e) {
            MsgError error = new MsgError();
            error.setEncodeError();
            error.setErrorMessage("Error while encoding interface lookup() request: Not able to write interface name '" + ((MsgInterfaceLookup)message).getCanonicalInterfaceName() + "' due to CharacterCodingException.");
            error.setRemoteObjectName(null);
            error.setInitSequenceId(((AbstractMessage)message).getSequence());
            error.setThrowable(e);
            this.sendEncodingError(out, session, error);
        }
        log.trace("position after: {}", (Object)out.position());
        log.trace("end");
    }
}

