/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageDecoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.codec.messages.MsgInterfaceLookupReturn;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgInterfaceLookupReturnDecoder
extends AbstractMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(MsgInterfaceLookupReturnDecoder.class);

    public MsgInterfaceLookupReturnDecoder() {
        super((byte)19);
    }

    @Override
    protected AbstractMessage decodeBody(IoSession session, IoBuffer in) {
        log.trace("decoding ...");
        MsgInterfaceLookupReturn m = new MsgInterfaceLookupReturn();
        try {
            String remoteObjectName = in.getPrefixedString(Charset.forName("UTF-8").newDecoder());
            int arraySize = in.getInt();
            log.trace("trying to read interfaces value. num of interfaces: {}", (Object)arraySize);
            String[] interfaces = new String[arraySize];
            for (int i = 0; i < arraySize; ++i) {
                String iface;
                interfaces[i] = iface = in.getPrefixedString(Charset.forName("UTF-8").newDecoder());
                log.trace("got interface=[{}]", (Object)interfaces[i]);
            }
            m.setErrorMsg(in.getPrefixedString(Charset.forName("UTF-8").newDecoder()));
            m.setInterfaces(interfaces);
            m.setRemoteObjectName(remoteObjectName);
        }
        catch (CharacterCodingException e) {
            MsgError error = new MsgError();
            error.setErrorMessage("Error while decoding interrace lookup return: Not able to read interface name due to CharacterCodingException.");
            error.setRemoteObjectName(null);
            error.setThrowable(e);
            return error;
        }
        log.trace("finished");
        return m;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }
}

