/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.LookupTable;
import host.anzo.simon.Simon;
import host.anzo.simon.Statics;
import host.anzo.simon.codec.base.AbstractMessageDecoder;
import host.anzo.simon.codec.messages.AbstractMessage;
import host.anzo.simon.codec.messages.MsgError;
import host.anzo.simon.codec.messages.MsgInvoke;
import host.anzo.simon.utils.SimonClassLoaderHelper;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgInvokeDecoder
extends AbstractMessageDecoder {
    private static final Logger log = LoggerFactory.getLogger(MsgInvokeDecoder.class);

    public MsgInvokeDecoder() {
        super((byte)2);
    }

    @Override
    protected AbstractMessage decodeBody(IoSession session, IoBuffer in) {
        MsgInvoke msgInvoke = new MsgInvoke();
        String remoteObjectName = null;
        try {
            LookupTable lookupTable = (LookupTable)session.getAttribute((Object)Statics.SESSION_ATTRIBUTE_LOOKUPTABLE);
            log.trace("start pos={} capacity={}", (Object)in.position(), (Object)in.capacity());
            remoteObjectName = in.getPrefixedString(Charset.forName("UTF-8").newDecoder());
            msgInvoke.setRemoteObjectName(remoteObjectName);
            log.trace("remote object name read ... remoteObjectName={} pos={}", (Object)remoteObjectName, (Object)in.position());
            long methodHash = in.getLong();
            log.trace("got method hash {}", (Object)methodHash);
            Method method = lookupTable.getMethod(msgInvoke.getRemoteObjectName(), methodHash);
            log.trace("method looked up ... pos={} method=[{}]", (Object)in.position(), (Object)method.toString());
            int argsLength = in.getInt();
            log.trace("args len read read ... pos={}", (Object)in.position());
            log.trace("getting {} args", (Object)argsLength);
            Object[] args = new Object[argsLength];
            for (int i = 0; i < argsLength; ++i) {
                try {
                    args[i] = in.getObject(SimonClassLoaderHelper.getClassLoader(Simon.class));
                }
                catch (Exception ex) {
                    Exception ex1 = new Exception("Problem reading method argument. Maybe argument isn't serializable?!");
                    ex1.initCause(ex.getCause());
                    ex1.setStackTrace(ex.getStackTrace());
                    log.error("Exception while reading arguments.", (Throwable)ex);
                    throw ex1;
                }
                log.trace("arg #{} read ... pos={} object={}", new Object[]{i, in.position(), args[i]});
            }
            msgInvoke.setArguments(args);
            msgInvoke.setRemoteObjectName(remoteObjectName);
            msgInvoke.setMethod(method);
        }
        catch (Exception e) {
            MsgError error = new MsgError();
            error.setErrorMessage("Error while decoding invoke request");
            error.setRemoteObjectName(remoteObjectName);
            error.setThrowable(e);
            return error;
        }
        log.trace("message={}", (Object)msgInvoke);
        return msgInvoke;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }
}

