/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageEncoder;
import host.anzo.simon.codec.messages.MsgRawChannelData;
import java.nio.ByteBuffer;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgRawChannelDataEncoder<T extends MsgRawChannelData>
extends AbstractMessageEncoder<T> {
    private static final Logger log = LoggerFactory.getLogger(MsgRawChannelDataEncoder.class);

    @Override
    protected void encodeBody(IoSession session, T message, IoBuffer out) {
        ByteBuffer bb = ((MsgRawChannelData)message).getData();
        if (bb.position() > 0) {
            bb.flip();
        }
        int dataSize = bb.limit();
        log.trace("begin. message={} dataSize={}", message, (Object)dataSize);
        out.putInt(((MsgRawChannelData)message).getChannelToken());
        out.put(bb);
        log.trace("end");
    }
}

