/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.codec.base;

import host.anzo.simon.codec.base.AbstractMessageEncoder;
import host.anzo.simon.codec.messages.MsgReleaseRef;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgReleaseRefEncoder<T extends MsgReleaseRef>
extends AbstractMessageEncoder<T> {
    private static final Logger log = LoggerFactory.getLogger(MsgReleaseRefEncoder.class);

    @Override
    protected void encodeBody(IoSession session, T message, IoBuffer out) {
        log.trace("begin. message=" + message);
        try {
            out.putPrefixedString((CharSequence)((MsgReleaseRef)message).getRefId(), Charset.forName("UTF-8").newEncoder());
        }
        catch (CharacterCodingException ex) {
            String errorMsg = "Failed to transfer reference release. error=" + ex.getMessage();
            log.warn(errorMsg);
        }
        log.trace("end");
    }
}

