/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.filetransmit;

import host.anzo.simon.RawChannelDataListener;
import host.anzo.simon.Simon;
import host.anzo.simon.annotation.SimonRemote;
import host.anzo.simon.filetransmit.FileReceiver;
import host.anzo.simon.filetransmit.FileReceiverProgressListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SimonRemote(value={FileReceiver.class})
public class DefaultFileReceiver
implements FileReceiver {
    private static final Logger log = LoggerFactory.getLogger(DefaultFileReceiver.class);
    public List<FileReceiverProgressListener> listeners = Collections.synchronizedList(new ArrayList());
    private File downloadFolder;

    public void setDownloadFolder(File folder) {
        if (!folder.exists()) {
            throw new IllegalArgumentException("Folder " + folder + " does not exist");
        }
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("Folder " + folder + " is not a folder");
        }
        this.downloadFolder = folder;
    }

    @Override
    public int requestChannelToken(String name, long length, boolean overwriteExisting) throws FileNotFoundException, IOException {
        return Simon.prepareRawChannel(new ChannelDataListener(new File(this.downloadFolder, name), length, overwriteExisting), this);
    }

    public void addProgressListener(FileReceiverProgressListener listener) {
        this.listeners.add(listener);
    }

    public void removeProgressListener(FileReceiverProgressListener listener) {
        this.listeners.remove(listener);
    }

    private List<FileReceiverProgressListener> getListenersCopy() {
        return new ArrayList<FileReceiverProgressListener>(this.listeners);
    }

    private class ChannelDataListener
    implements RawChannelDataListener {
        private File f;
        private FileChannel fc;
        private final long length;
        private long bytesRead = 0L;

        public ChannelDataListener(File f, long length, boolean overwriteExisting) throws FileNotFoundException, IOException {
            this.f = f;
            for (FileReceiverProgressListener listener : DefaultFileReceiver.this.getListenersCopy()) {
                listener.started(f, length);
            }
            if (f.exists() && !overwriteExisting) {
                IOException e = new IOException("File " + f + " already exists");
                for (FileReceiverProgressListener listener : DefaultFileReceiver.this.getListenersCopy()) {
                    listener.aborted(f, e);
                }
                throw e;
            }
            f.delete();
            this.fc = new FileOutputStream(f).getChannel();
            this.length = length;
            log.debug("Ready for receiving file {} with size {}", (Object)f.getAbsolutePath(), (Object)length);
        }

        @Override
        public void write(ByteBuffer data) {
            try {
                log.trace("Receiving chunk ...");
                this.bytesRead += (long)data.limit();
                for (FileReceiverProgressListener listener : DefaultFileReceiver.this.getListenersCopy()) {
                    listener.inProgress(this.f, this.bytesRead, this.length);
                }
                this.fc.write(data);
            }
            catch (IOException ex) {
                try {
                    log.warn("Receiving of file {} aborted due to {}", (Object)this.f, (Object)ex);
                    for (FileReceiverProgressListener listener : DefaultFileReceiver.this.getListenersCopy()) {
                        listener.aborted(this.f, ex);
                    }
                    this.fc.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void close() {
            if (this.fc.isOpen()) {
                try {
                    if (this.bytesRead != this.length) {
                        String msg = "Received file " + this.f + " does not match expected file size. Found: " + this.bytesRead + ". Expected: " + this.length;
                        for (FileReceiverProgressListener listener : DefaultFileReceiver.this.getListenersCopy()) {
                            listener.aborted(this.f, new IOException(msg));
                        }
                        log.warn(msg);
                    } else {
                        for (FileReceiverProgressListener listener : DefaultFileReceiver.this.getListenersCopy()) {
                            listener.completed(this.f);
                        }
                    }
                    log.debug("Receiving done");
                    this.fc.close();
                }
                catch (IOException ex) {
                    log.warn("Problem closing received file " + this.f, (Throwable)ex);
                }
            }
        }
    }
}

