/*
 * Decompiled with CFR 0.152.
 */
package host.anzo.simon.utils;

import host.anzo.simon.SimonProxy;
import host.anzo.simon.SimonRemoteMarker;
import host.anzo.simon.annotation.SimonRemote;
import host.anzo.simon.codec.base.SimonProtocolCodecFactory;
import host.anzo.simon.exceptions.IllegalRemoteObjectException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    @Deprecated
    public static boolean DEBUG = false;
    private static final WeakHashMap<Method, Long> methodHashes = new WeakHashMap();
    private static final String SIMON_REMOTE_ANNOTATION_CLASSNAME = SimonRemote.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long computeMethodHash(Method m) {
        Long hash;
        WeakHashMap<Method, Long> weakHashMap = methodHashes;
        synchronized (weakHashMap) {
            hash = methodHashes.get(m);
        }
        if (hash != null) {
            log.trace("Got hash from map. map contains {} entries.", (Object)methodHashes.size());
            return hash;
        }
        long result = 0L;
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(127);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            DigestOutputStream out = new DigestOutputStream(byteArray, md);
            out.write(m.toGenericString().getBytes());
            out.flush();
            byte[] hasharray = md.digest();
            for (int i = 0; i < Math.min(8, hasharray.length); ++i) {
                result += (long)(hasharray[i] & 0xFF) << i * 8;
            }
        }
        catch (IOException ignore) {
            result = -1L;
        }
        catch (NoSuchAlgorithmException complain) {
            throw new SecurityException(complain.getMessage());
        }
        WeakHashMap<Method, Long> weakHashMap2 = methodHashes;
        synchronized (weakHashMap2) {
            methodHashes.put(m, result);
            log.trace("computed new hash. map now contains {} entries.", (Object)methodHashes.size());
        }
        return result;
    }

    public static SimonProtocolCodecFactory getProtocolFactoryInstance(String protocolFactory) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> clazz = Class.forName(protocolFactory);
        try {
            return (SimonProtocolCodecFactory)((Object)clazz.newInstance());
        }
        catch (ClassCastException e) {
            throw new ClassCastException("The given class '" + protocolFactory + "' must extend '" + SimonProtocolCodecFactory.class.getCanonicalName() + "' !");
        }
    }

    public static String longToHexString(long l) {
        StringBuilder id = new StringBuilder();
        id.append(Long.toHexString(l).toUpperCase());
        while (id.length() < 8) {
            id.insert(0, "0");
        }
        id.insert(0, "0x");
        return id.toString();
    }

    public static byte booleanToByte(boolean bool) {
        return bool ? (byte)-1 : 0;
    }

    public static boolean byteToBoolean(byte b) throws IllegalArgumentException {
        switch (b) {
            case -1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new IllegalArgumentException("only 0xFF and 0x00 value allowed for 'byte-to-boolean' conversion!");
    }

    public static Class<?> @NotNull [] findAllRemoteInterfaces(Class<?> clazz) {
        Set<Class<?>> interfaceSet = Utils.doFindAllRemoteInterfaces(clazz);
        Class[] interfaces = new Class[interfaceSet.size()];
        if (log.isTraceEnabled()) {
            log.trace("found interfaces: {}", (Object)Arrays.toString(interfaceSet.toArray(interfaces)));
        }
        return interfaceSet.toArray(interfaces);
    }

    @NotNull
    private static Set<Class<?>> doFindAllRemoteInterfaces(Class<?> clazz) {
        HashSet interfaceSet = new HashSet();
        if (clazz == null) {
            return interfaceSet;
        }
        String type = clazz.isInterface() ? "interface" : "class";
        SimonRemote annotation = clazz.getAnnotation(SimonRemote.class);
        if (annotation != null) {
            log.trace("SimonRemote annotation found for {} {}", (Object)type, (Object)clazz.getName());
            Object[] remoteInterfaces = annotation.value();
            if (remoteInterfaces.length > 0) {
                log.trace("SimonRemote annotation has remote interfaces specified. Adding: {}", (Object)Arrays.toString(remoteInterfaces));
                Collections.addAll(interfaceSet, remoteInterfaces);
            } else {
                if (clazz.isInterface()) {
                    interfaceSet.add(clazz);
                }
                Collections.addAll(interfaceSet, clazz.getInterfaces());
            }
        } else {
            log.trace("No SimonRemote annotation found for {} {}. Searching for interfaces that extend SimonRemoteMarker or use SimonRemote Annotation.", (Object)type, (Object)clazz.getName());
            for (Class<?> interfaze : clazz.getInterfaces()) {
                if (interfaze.isAnnotationPresent(SimonRemote.class)) {
                    interfaceSet.add(interfaze);
                    for (Class<?> parentInterface : interfaze.getInterfaces()) {
                        interfaceSet.addAll(Utils.doFindAllRemoteInterfaces(parentInterface));
                    }
                    continue;
                }
                interfaceSet.addAll(Utils.doFindAllRemoteInterfaces(interfaze.getSuperclass()));
            }
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Object.class)) {
                interfaceSet.addAll(Utils.doFindAllRemoteInterfaces(clazz.getSuperclass()));
            }
        }
        return interfaceSet;
    }

    public static boolean isRemoteAnnotated(Object remoteObject) {
        ClassLoader remoteObjectCL;
        if (remoteObject == null) {
            throw new IllegalArgumentException("Cannot check a null-argument. You have to provide a proxy object instance ...");
        }
        boolean isRemoteAnnotated = remoteObject.getClass().isAnnotationPresent(SimonRemote.class);
        if (!isRemoteAnnotated && (remoteObjectCL = remoteObject.getClass().getClassLoader()) != null) {
            try {
                isRemoteAnnotated = remoteObject.getClass().isAnnotationPresent(remoteObjectCL.loadClass(SIMON_REMOTE_ANNOTATION_CLASSNAME));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return isRemoteAnnotated;
    }

    public static Class<?>[] getRemoteAnnotationValue(Object remoteObject) {
        if (remoteObject == null) {
            throw new IllegalArgumentException("Cannot check a null-argument. You have to provide a proxy object instance ...");
        }
        return remoteObject.getClass().getAnnotation(SimonRemote.class).value();
    }

    public static boolean isValidRemote(Object remoteObject) {
        if (remoteObject == null) {
            return false;
        }
        if (Utils.isRemoteAnnotated(remoteObject)) {
            if (remoteObject.getClass().getInterfaces().length > 0 || Utils.getRemoteAnnotationValue(remoteObject).length > 0) {
                return true;
            }
            throw new IllegalRemoteObjectException("There is no interface with the remote object of type '" + remoteObject.getClass().getCanonicalName() + "' linked. Add a 'value' parameter with array of interfaces (at least one interface) to the SimonRemote annotation, or let the class implement an interface");
        }
        return Utils.getMarker(remoteObject) != null;
    }

    public static boolean isSimonProxy(Object o) {
        if (o instanceof Proxy) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(o);
            log.trace("Got invocation handler ...");
            if (invocationHandler instanceof SimonProxy) {
                log.trace("Yeeha. It's a SimonProxy ...");
                return true;
            }
        }
        return false;
    }

    public static SimonRemoteMarker getMarker(Object o) {
        InvocationHandler invocationHandler;
        if (o instanceof Proxy && (invocationHandler = Proxy.getInvocationHandler(o)) instanceof SimonRemoteMarker) {
            return (SimonRemoteMarker)invocationHandler;
        }
        return null;
    }

    private static void putInterfacesToStack(Stack<Class> stack, @NotNull Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> iClazz : interfaces = clazz.getInterfaces()) {
            stack.push(iClazz);
        }
    }

    public static void putAllInterfaceNames(@NotNull Object object, List<String> interfaceNames) {
        Stack<Class> stack = new Stack<Class>();
        Utils.putInterfacesToStack(stack, object.getClass());
        while (!stack.empty()) {
            Class iClazz = stack.pop();
            String iClazzName = iClazz.getCanonicalName();
            log.trace("Adding {} to the list of remote interfaces", (Object)iClazzName);
            if (!interfaceNames.contains(iClazzName)) {
                interfaceNames.add(iClazzName);
            }
            Utils.putInterfacesToStack(stack, iClazz);
        }
    }

    public static String getStackTraceAsString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static Throwable getRootCause(Throwable th) {
        if (th instanceof SAXException) {
            SAXException sax = (SAXException)th;
            if (sax.getException() != null) {
                return Utils.getRootCause(sax.getException());
            }
        } else if (th instanceof SQLException) {
            SQLException sql = (SQLException)th;
            if (sql.getNextException() != null) {
                return Utils.getRootCause(sql.getNextException());
            }
        } else if (th.getCause() != null) {
            return Utils.getRootCause(th.getCause());
        }
        return th;
    }

    public static final int hash(Object object) {
        if (object == null) {
            return 0;
        }
        int hash = 0;
        hash ^= object.hashCode();
        hash ^= hash >>> 20 ^ hash >>> 12;
        return hash ^ hash >>> 7 ^ hash >>> 4;
    }

    private static boolean isDalvikVM() {
        return System.getProperty("java.vm.specification.name", "").equals("Dalvik Virtual Machine Specification") && System.getProperty("java.vm.vendor", "").equals("The Android Project");
    }

    public static boolean registerMBean(Object o, String objectNameOfMBean) {
        if (Utils.isDalvikVM()) {
            log.info("Running on Android. Skipping registration on MBeanServer for [{}]", (Object)objectNameOfMBean);
            return false;
        }
        try {
            String cnManagementFactory = "java.lang.management.ManagementFactory";
            String mnGetPlatformMBeanServer = "getPlatformMBeanServer";
            Class<?> cManagementFactory = Class.forName(cnManagementFactory);
            Method mGetPlatformMBeanServer = cManagementFactory.getDeclaredMethod(mnGetPlatformMBeanServer, new Class[0]);
            Object oMBeanServer = mGetPlatformMBeanServer.invoke(null, new Object[0]);
            String cnObjectName = "javax.management.ObjectName";
            Class<?> cObjectName = Class.forName(cnObjectName);
            Constructor<?> constructor = cObjectName.getConstructor(String.class);
            Object oObjectName = constructor.newInstance(objectNameOfMBean);
            String cnMBeanServer = "javax.management.MBeanServer";
            String mnRegisterMBean = "registerMBean";
            Class<?> cMBeanServer = Class.forName(cnMBeanServer);
            Method mRegisterMBean = cMBeanServer.getMethod(mnRegisterMBean, Object.class, cObjectName);
            mRegisterMBean.invoke(oMBeanServer, o, oObjectName);
            return true;
        }
        catch (Throwable t) {
            log.warn("Cannot register [{}] on MBeanServer.", (Object)objectNameOfMBean, (Object)t);
            return false;
        }
    }
}

